package com.tandbergtv.cms.portal.content.client.tab.list.assettable;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.tandbergtv.cms.portal.content.client.tab.list.TitleListPanel;

/**
 * Listener which captures the event when the user clicks on the edit link in the asset list page
 * 
 * @author spuranik
 */
public class EditLinkListener implements ClickHandler {

	/* Properties */
	private Long titleId;
	private TitleListPanel view;

	/**
	 * Constructor
	 * 
	 * @param id The title Id
	 * @param spec The specification name
	 * @param panel The Asset List Panel
	 */
	public EditLinkListener(Long id, TitleListPanel panel) {
		this.titleId = id;
		this.view = panel;
	}

	/* Handle the click event for the edit title link */
	@Override
	public void onClick(ClickEvent event) {
		/* Display the title view */
		view.showTitleDetails(titleId);
	}
}
