package com.tandbergtv.cms.portal.content.client.tab.list.assettable;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.cms.portal.content.client.i18n.ContentConstants;
import com.tandbergtv.cms.portal.content.client.model.UiTable;
import com.tandbergtv.cms.portal.content.client.rpc.SpecificationService;
import com.tandbergtv.cms.portal.content.client.rpc.SpecificationServiceAsync;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UIFieldType;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UiColumn;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;

/**
 * Class which helps with all quick info work
 * 
 * @author spuranik
 *
 */
public class QuickInfoColumnProvider {

	/* static columns for quick info */
	public static String TITLE_ASSET_TYPE = "PACKAGE/TITLE";
	public static String TITLE_PROVIDER_ID_XPATH = "/Fields/ProviderInfo/Identifier/Id";
	public static String TITLE_BRIEF_XPATH = "/Fields/Title/ShortTitle/Value";
	public static String TITLE_STATUS = "status";
	
	/* table which has other fields which should be included in the quick info column */
	private static String QUICK_INFO_COL_TABLE = "quickInfoSearchColumns";
	
	/* list of columns for fields comprising quick info column */
	private List<UiColumn> fields;
	
	private static QuickInfoColumnProvider _instance;
	
	private ContentConstants constants = (ContentConstants) GWT.create(ContentConstants.class);
	
	private QuickInfoColumnProvider() {
		_instance = this;
	}
	
	public static QuickInfoColumnProvider getInstance() {
		if(_instance == null) {
			return new QuickInfoColumnProvider(); 
		} else {
			return _instance;
		}
	}
	
	/**
	 * returns column info about the comprising fields (static + configurable) 
	 * 
	 * @return
	 */
	public void getColumns(final NeptuneAsyncCallback<List<UiColumn>> callback) {
		/* if fields have already been fetched, no need to go back to the server */
		if(fields != null) {
			callback.onSuccess(fields);
			return;
		}
		
		NeptuneAsyncCallback<List<UiColumn>> fieldCallback = new NeptuneAsyncCallback<List<UiColumn>>() {
			@Override
			public void onNeptuneFailure(Throwable caught) {
				callback.onFailure(caught);
			}

			@Override
			public void onNeptuneSuccess(List<UiColumn> dynamicFields) {
				fields = new ArrayList<UiColumn>();
				fields.addAll(dynamicFields);
				// after getting the dynamic fields add the static ones
				fields.addAll(getStaticColumns());				
				callback.onSuccess(fields);
			}			
		};
		
		buildDynamicColumns(fieldCallback);
	}

	/**
	 * gets the columns specified in the quick info table 
	 * 
	 * @param callback
	 */
	private void buildDynamicColumns(final AsyncCallback<List<UiColumn>> callback) {
		SpecificationServiceAsync specService = GWT.create(SpecificationService.class);
		specService.getTable(QUICK_INFO_COL_TABLE, new NeptuneAsyncCallback<UiTable>() {
			@Override
			public void onNeptuneFailure(Throwable caught) {
				callback.onFailure(caught);
			}

			@Override
			public void onNeptuneSuccess(UiTable table) {				
				callback.onSuccess(table.getColumns());
			}
		});		
	}

	/**
	 * title status, provider id and title name are added by default
	 * 
	 * @return
	 */
	private List<UiColumn> getStaticColumns() {
		List<UiColumn> staticCols = new ArrayList<UiColumn>();
		
		// title status
		UiColumn statusCol = new UiColumn();
		statusCol.setName(TITLE_STATUS);
		statusCol.setFieldType(UIFieldType.PMM_TITLE);
		statusCol.setDataType(UiColumn.DataType.STRING);
		statusCol.setIsMultiValued(false);
		statusCol.setDisplayName(constants.status());
		staticCols.add(statusCol);
		
		// title provider id
		UiColumn providerIdCol = new UiColumn();
		providerIdCol.setSectionName(TITLE_ASSET_TYPE);
		providerIdCol.setName(TITLE_PROVIDER_ID_XPATH);
		providerIdCol.setFieldType(UIFieldType.ASSET);
		providerIdCol.setDataType(UiColumn.DataType.STRING);
		providerIdCol.setIsMultiValued(false);
		providerIdCol.setDisplayName(constants.providerId());
		staticCols.add(providerIdCol);
		
		// title name
		UiColumn titleNameCol = new UiColumn();
		titleNameCol.setSectionName(TITLE_ASSET_TYPE);
		titleNameCol.setName(TITLE_BRIEF_XPATH);
		titleNameCol.setFieldType(UIFieldType.ASSET);
		titleNameCol.setDataType(UiColumn.DataType.STRING);
		titleNameCol.setIsMultiValued(false);
		titleNameCol.setDisplayName(constants.titleBrief());
		staticCols.add(titleNameCol);
		
		return staticCols;
	}

	public List<UiColumn> getFields() {
		return fields;
	}
	
}
