package com.tandbergtv.cms.portal.content.client.tab.list.assettable;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.i18n.ContentConstants;
import com.tandbergtv.cms.portal.content.client.model.UiField;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UiColumn;
import com.tandbergtv.cms.portal.ui.title.client.view.bundle.TitleClientBundle;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

/**
 * class which is responsible to build the quick info column view
 * 
 * It's horrible to implement a string view just because the table column is
 * fixed to be a string type
 * 
 * @author spuranik
 * 
 */
public class QuickInfoViewBuilder implements View<String> {

	/* all quick info fields that were retrieved by search */
	private List<UiField> fields;
	
	private ContentConstants displayConstants = (ContentConstants) GWT.create(ContentConstants.class);
	private static String FIELD_NAME_VALUE_DELIMITER = ":";
	private static String QUICK_INFO_LABEL_STYLE = "QuickInfo-Label";	
	
	public QuickInfoViewBuilder(TitleRecord record) {
		this.fields = extractQuickInfoFields(record.getTitle().getFields());
	}
	
	private List<UiField> extractQuickInfoFields(List<UiField> allFields) {
		List<UiField> qInfoFields = new ArrayList<UiField>();
		
		// the columns are already read from the server by now 
		List<UiColumn> qInfoCols = QuickInfoColumnProvider.getInstance().getFields();
		for (UiColumn uic : qInfoCols) {
			for (UiField f : allFields) {
				if (uic.getName().equals(f.getName())) {
					// if there is no section name or if both the section names match
					if((uic.getSectionName() == null && f.getParentAssetType() == null) || 
					 (uic.getSectionName().equals(f.getParentAssetType()))) {
						qInfoFields.add(f);
						break;
					}
				}
			}
		}
		return qInfoFields;
	}

	@Override
	public String getStyleName() {
		return null;
	}

	@Override
	public Widget getWidget() {
		FlexTable table = new FlexTable();
		
		// add default fields first
		Widget staticFieldWidget = getWidgetForStaticInfo();
		table.setWidget(0, 0, staticFieldWidget);
		
		Widget dynamicFieldWidget = getDynamicFieldWidgets();
		table.setWidget(1, 0, dynamicFieldWidget);
		
		return table;
	}

	private VerticalContainer getDynamicFieldWidgets() {
		VerticalContainer panel = new VerticalContainer();
		
		for(UiField f : fields) {
			if(!isStaticField(f)) {
				HorizontalContainer fieldContainer = new HorizontalContainer();
				
				LabelWidget fieldNameWidget = new LabelWidget(f.getDisplayName() + FIELD_NAME_VALUE_DELIMITER);
				fieldNameWidget.addStyleName(QUICK_INFO_LABEL_STYLE);
				LabelWidget fieldValueWidget = new LabelWidget(f.getValue());				
				fieldContainer.add(fieldNameWidget);
				fieldContainer.add(fieldValueWidget);
				
				panel.add(fieldContainer);
			}
		}
		return panel;
	}

	private VerticalPanel getWidgetForStaticInfo() {
		VerticalContainer staticPanel = new VerticalContainer();
		
		HorizontalContainer assetIdpanel = new HorizontalContainer();
		// TODO: set style
		assetIdpanel.setSpacing(3);
		
		// handle title status
		ImageWidget statusImage = new ImageWidget();
		TitleClientBundle bundle = new TitleClientBundle();
		String status = getStatusFieldValue();
		bundle.updateTitleStatusIcon(statusImage, status);
		assetIdpanel.add(statusImage);
		
		// handle provider id
		// TODO: check styling
		LabelWidget providerIdLabel = new LabelWidget(displayConstants.providerId() + FIELD_NAME_VALUE_DELIMITER);
		providerIdLabel.addStyleName(QUICK_INFO_LABEL_STYLE);
		LabelWidget providerValueLabel = new LabelWidget(getProviderIdFieldValue());
		assetIdpanel.add(providerIdLabel);
		assetIdpanel.add(providerValueLabel);
		staticPanel.add(assetIdpanel);
		
		// handle title brief
		HorizontalContainer tbPanel = new HorizontalContainer();
		LabelWidget titleBriefLabel = new LabelWidget(displayConstants.titleBrief() + FIELD_NAME_VALUE_DELIMITER);
		titleBriefLabel.addStyleName(QUICK_INFO_LABEL_STYLE);
		LabelWidget titleBriefValueLabel = new LabelWidget(getTitleBriefFieldValue());
		tbPanel.add(titleBriefLabel);
		tbPanel.add(titleBriefValueLabel);		
		staticPanel.add(tbPanel);
		
		return staticPanel;
	}

	private String getStatusFieldValue() {
		for(UiField f : fields) {
			if(f.getName().equals(QuickInfoColumnProvider.TITLE_STATUS)) {
				return f.getValue();
			}
		}
		return null;
	}
	
	private String getProviderIdFieldValue() {
		for(UiField f : fields) {
			if (f.getName().equals(
					QuickInfoColumnProvider.TITLE_PROVIDER_ID_XPATH)
					&& f.getParentAssetType().equals(QuickInfoColumnProvider.TITLE_ASSET_TYPE)) {
				return f.getValue();
			}
		}
		return null;
	}
	
	private String getTitleBriefFieldValue() {
		for(UiField f : fields) {
			if (f.getName().equals(
					QuickInfoColumnProvider.TITLE_BRIEF_XPATH)
					&& f.getParentAssetType().equals(QuickInfoColumnProvider.TITLE_ASSET_TYPE)) {
				return f.getValue();
			}
		}
		return null;
	}

	@Override
	public void release() {
	}

	/**
	 * title status, title brief and provider id are static fields. If the field
	 * passed in is one of them, it returns true else false.
	 * 
	 * @param f
	 * @return
	 */
	private boolean isStaticField(UiField f) {
		// title status
		if(f.getName().equals(QuickInfoColumnProvider.TITLE_STATUS)) {
			return true;
		}
		
		// provider id
		if (f.getName().equals(QuickInfoColumnProvider.TITLE_PROVIDER_ID_XPATH)
				&& f.getParentAssetType().equals(
						QuickInfoColumnProvider.TITLE_ASSET_TYPE)) {
			return true;
		}
		
		// title brief
		if (f.getName().equals(QuickInfoColumnProvider.TITLE_BRIEF_XPATH)
				&& f.getParentAssetType().equals(
						QuickInfoColumnProvider.TITLE_ASSET_TYPE)) {
			return true;
		}
		
		return false;
	}
}
