package com.tandbergtv.cms.portal.content.client.tab.list.assettable;

import java.util.ArrayList;
import java.util.List;

import com.tandbergtv.cms.portal.content.client.tab.list.TitleListPanel;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UiColumn;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;

/**
 * Util class which builds the record view for a search results column 
 * 
 * @author spuranik
 *
 */
public class SearchResultColumnBuilder {
	private TitleListPanel panel;
	private List<Column<?, TitleRecord>> columns;
	
	public SearchResultColumnBuilder() {	}
	
	public SearchResultColumnBuilder(TitleListPanel panel) {
		this.panel = panel;
	}

	/**
	 * Given the list of search result columns, builds the record underneath it
	 * and the view that renders the data
	 * 
	 * @param searchResultsColumns
	 * @return
	 */
	public List<Column<?, TitleRecord>> buildRecordForColumns(List<UiColumn> searchResultsColumns) {

		columns = new ArrayList<Column<?, TitleRecord>>();
		
		for (final UiColumn uiColumn : searchResultsColumns) {
			SearchResultTableColumn column = new SearchResultTableColumn(uiColumn, panel);
			column.setCellStyle(column.getColumnCellStyle());
			columns.add(column);
		}
		return columns;
	}
	
	/**
	 * Given the list of search results columns, returns table sortable columns 
	 * 
	 * @param searchResultsColumns
	 * @return
	 */
	public List<Column<?, TitleRecord>> getSortColumns(List<UiColumn> searchResultsColumns) {
		List<Column<?, TitleRecord>> sortCols = new ArrayList<Column<?, TitleRecord>>();
		
		for(UiColumn uiCol : searchResultsColumns) {
			if(uiCol.isSortable()) {
				for(Column<?, TitleRecord> c : this.columns) {
					if (uiCol.getInternalName().equals(c.getName())
							&& uiCol.getDisplayName().equals(c.getDisplayName())) {
						sortCols.add(c);
						break;
					}
				}		
			}
		}
		
		return sortCols;
	}
}
