package com.tandbergtv.cms.portal.content.client.tab.list.assettable;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.cms.portal.content.client.model.UiTable;
import com.tandbergtv.cms.portal.content.client.rpc.SpecificationService;
import com.tandbergtv.cms.portal.content.client.rpc.SpecificationServiceAsync;
import com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UiColumn;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;

/**
 * This class communicates with the backend to find the columns which the user
 * can choose to display in the search results page.
 * 
 * @author spuranik
 * 
 */
public class SearchResultColumnProvider {

	 private static String SEARCH_RESULTS_DISPLAY_COL_TABLE = "SearchResultsColumns";
	 private static String SERIES_SEARCH_RESULTS_DISPLAY_COL_TABLE = "SeriesSearchResultsColumns";
	 
	 private UiCriteriaMode criteriaMode;
	 
	 public SearchResultColumnProvider(UiCriteriaMode criteriaMode) {
		 this.criteriaMode = criteriaMode;
	 }
	 
	/**
	 * returns the list of ui columns the user can choose to view in the search
	 * results page
	 * 
	 * @return
	 */
	public void getDisplayColumns(final AsyncCallback<UiTable> callback) {
		SpecificationServiceAsync specService = GWT.create(SpecificationService.class);
		specService.getTable(SEARCH_RESULTS_DISPLAY_COL_TABLE, new NeptuneAsyncCallback<UiTable>() {
			@Override
			public void onNeptuneFailure(Throwable caught) {
				callback.onFailure(caught);
			}

			@Override
			public void onNeptuneSuccess(UiTable table) {
				callback.onSuccess(table);
			}
		});
	}

	/**
	 * returns the list of columns which the user can choose to sort the search
	 * results on.
	 * 
	 * @return
	 */
	public List<UiColumn> getSortColumns() {
		return new ArrayList<UiColumn>();
	}

	/**
	 * returns the list of columns corresponding to the fields encapsulated in
	 * the quick info column
	 * 
	 * @return
	 */
	public List<UiColumn> getQuickInfoFields() {
		return new ArrayList<UiColumn>();
	}
	
	/**
	 * returns the list of search display and sort columns for that spec.
	 * 
	 * @param callback
	 */
	public void getSearchColumns(final AsyncCallback<SearchColumns> callback) {
		String tablename = criteriaMode == UiCriteriaMode.EPISODE ? SEARCH_RESULTS_DISPLAY_COL_TABLE
				: SERIES_SEARCH_RESULTS_DISPLAY_COL_TABLE;
		SpecificationServiceAsync specService = GWT.create(SpecificationService.class);
		specService.getTable(tablename, new NeptuneAsyncCallback<UiTable>() {
					@Override
					public void onNeptuneFailure(Throwable caught) {
						callback.onFailure(caught);
					}

					@Override
					public void onNeptuneSuccess(UiTable table) {
						SearchColumns cols = new SearchColumns();
						
						cols.setDisplayColumns(table.getColumns());
						cols.setSortColumns(getSortCols(table));
						cols.setDefaultInternalSortColumnName(table.getDefaultSortColumnName());
						callback.onSuccess(cols);
					}
				});
	}
	
	private List<UiColumn> getSortCols(UiTable table) {
		List<UiColumn> sortCols = new ArrayList<UiColumn>();
		
		for(UiColumn c : table.getColumns()) {
			if(c.isSortable()) {
				sortCols.add(c);
			}
		}
		return sortCols;
	}
	
	/**
	 * Value object passed comprising of all types of columns.
	 *
	 */
	public class SearchColumns {
		List<UiColumn> displayColumns;
		List<UiColumn> sortColumns;
		String defaultInternalSortColumnName;

		public SearchColumns() {
			this.displayColumns = new ArrayList<UiColumn>();
			this.sortColumns = new ArrayList<UiColumn>();
			this.defaultInternalSortColumnName = "";
		}
		
		public List<UiColumn> getDisplayColumns() {
			return displayColumns;
		}

		public void setDisplayColumns(List<UiColumn> displayColumns) {
			this.displayColumns = displayColumns;
		}

		public List<UiColumn> getSortColumns() {
			return sortColumns;
		}

		public void setSortColumns(List<UiColumn> sortColumns) {
			this.sortColumns = sortColumns;
		}

		public String getDefaultInternalSortColumnName() {
			return defaultInternalSortColumnName;
		}

		public void setDefaultInternalSortColumnName(
				String defaultInternalSortColumnName) {
			this.defaultInternalSortColumnName = defaultInternalSortColumnName;
		}
	}
}


