package com.tandbergtv.cms.portal.content.client.tab.list.assettable;

import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.model.UISearchResultRec;
import com.tandbergtv.cms.portal.content.client.model.UiField;
import com.tandbergtv.cms.portal.content.client.tab.list.TitleListPanel;
import com.tandbergtv.cms.portal.content.client.tab.search.SearchSpecialColumns;
import com.tandbergtv.cms.portal.content.client.title.view.thumbnail.TitleThumbnailWidget;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UiColumn;
import com.tandbergtv.cms.portal.ui.title.client.view.bundle.TitleClientBundle;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ColumnBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableConstants;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.label.LabelStringView;

public class SearchResultTableColumn extends ColumnBase<String, TitleRecord> {
	
	private UiColumn uiColumn;
	private TitleListPanel panel;
	
	// styles
	private static final String STYLE_THUMBNAIL_IMAGE = "content-TitleListPanel-thumbnailImage";
	private static final String ID_COL_WIDTH = "5%";
	
	public SearchResultTableColumn(UiColumn uiColumn, TitleListPanel panel) {
		super(uiColumn.getInternalName(), uiColumn.getDisplayName());
		this.uiColumn = uiColumn;
		this.panel = panel;
	}
	
	public View<String> getView(TitleRecord record) {
		UISearchResultRec t = record.getTitle();

		if (isThumbnailColumn(uiColumn)) {
			return new ThumbnailView(record);
		}
		
		if (isQuickInfoColumn(uiColumn)) {
			return new QuickInfoViewBuilder(record);
		}

		for (UiField f : t.getFields()) {
			String colInternalName = TableColumnNameHelper
					.getColumnName(f.getName(), f.getParentAssetType());
			LabelStringView view = null;
			if (colInternalName.equals(getName())) {
				if (getName().equalsIgnoreCase(SearchSpecialColumns.STATUS)) {
					return new ImageView(f.getValue());
				} else {
					view = new LabelStringView(f.getValue());
				}
				if (getName().equalsIgnoreCase(SearchSpecialColumns.ID_COLUMN)) {
					view.getWidget().addClickHandler(new EditLinkListener(t.getId(),panel));
					view.setStyleName(TableConstants.STYLE_DATA_LINK);
				}
				return view;
			}
		}
		return new LabelStringView("ERROR: Value not available");
	}

	public UiColumn getUiColumn() {
		return uiColumn;
	}

	public void setUiColumn(UiColumn uiColumn) {
		this.uiColumn = uiColumn;
	}
	
	/* Determine if this is the thumbnail column */
	public static boolean isThumbnailColumn(UiColumn column) {
		return SearchSpecialColumns.THUMBNAIL_COLUMN.equals(column.getName());
	}
	
	/* Determine if this is the quick info column */
	public static boolean isQuickInfoColumn(UiColumn column) {
		return SearchSpecialColumns.QUICK_INFO_COLUMN.equals(column.getName());
	}
	
	/* Determine if this is the id column */
	public static boolean isIdColumn(UiColumn column) {
		return SearchSpecialColumns.ID_COLUMN.equals(column.getName());
	}
	
	/*
	 * Determine the style to use based on the data type of the column data
	 */
	public String getColumnCellStyle() {
		if (isThumbnailColumn(uiColumn)) {
			return TableConstants.STYLE_DATACELL_ICON;
		}

		String style = TableConstants.STYLE_DATACELL_GENERAL;
		if (uiColumn.getDataType() != null) {
			switch (uiColumn.getDataType()) {
				case BOOLEAN:
				case STRING:
					if(uiColumn.getName().equalsIgnoreCase(SearchSpecialColumns.STATUS))
						style = TableConstants.STYLE_DATACELL_ICON;
					else
						style = TableConstants.STYLE_DATACELL_TEXT;					
					break;
				case INTEGER:
				case FLOAT:
					style = TableConstants.STYLE_DATACELL_NUMERIC;
					break;
				case DATE:
				case TIME:
					style = TableConstants.STYLE_DATACELL_DATE;
					break;
			}
		}

		return style;
	}
	
	/**
	 * view for thumbnail column
	 * 
	 */
	private static class ThumbnailView implements View<String> {
		TitleRecord record;

		public ThumbnailView(TitleRecord record) {
			this.record = record;
		}

		@Override
		public Widget getWidget() {
			TitleThumbnailWidget widget = new TitleThumbnailWidget();
			widget.addStyleName(STYLE_THUMBNAIL_IMAGE);
			widget.setInput(record.getTitle().getId(), null);
			return widget;
		}

		@Override
		public void release() {
		}

		@Override
		public String getStyleName() {
			return null;
		}
	};
	
	/**
	 * view for image columns e.g. status
	 *
	 */
	private class ImageView implements View<String> {

		String status;
		public ImageView(String status) {
			this.status = status;
		}

		@Override
		public Widget getWidget() {
			ImageWidget statusImage = new ImageWidget();
			TitleClientBundle bundle = new TitleClientBundle();
			bundle.updateTitleStatusIcon(statusImage, status);
			return statusImage;
		}	

		@Override
		public void release() {
		}
		
		@Override
		public String getStyleName() {
			return null;
		}		
	}
	
	public String getColumnWidth() {
		if(isIdColumn(this.uiColumn)) {
			return ID_COL_WIDTH;
		} 
		return ""; 
	}
}
