package com.tandbergtv.cms.portal.content.client.tab.list.assettable;

/**
 * Helper class which splits and combines the section name and metadata field
 * name
 * 
 * @author spuranik
 * 
 */
public class TableColumnNameHelper {

	private static String COLUMN_NAME_DELIMITER = "|";
	private static String ESCAPED_COLUMN_NAME_DELIMITER = "\\|";
	private static int COLUMN_NAME_PIECE_COUNT = 2;
	private static int SECTION_INDEX = 0;
	private static int FIELD_NAME_INDEX = 1;

	public static String getColumnName(String name, String sectionName) {
		String section = sectionName;
		String fieldName = name;
		if (sectionName != null) {
			section = sectionName;
			return section + COLUMN_NAME_DELIMITER + fieldName;
		}
		// Don't prefix the colname if its not a metadata field. Only metatdata
		// fields will have a section e.g. movie, poster..
		return fieldName;
	}

	public static String getColumnName(String internalName) {
		return (internalName.split(ESCAPED_COLUMN_NAME_DELIMITER))[FIELD_NAME_INDEX];
	}

	public static String getSectionName(String internalName) {
		return (internalName.split(ESCAPED_COLUMN_NAME_DELIMITER))[SECTION_INDEX];
	}

	public static boolean isMetdataField(String internalName) {
		return internalName.split(ESCAPED_COLUMN_NAME_DELIMITER).length == COLUMN_NAME_PIECE_COUNT;
	}
}
