package com.tandbergtv.cms.portal.content.client.tab.list.assettable;

import com.tandbergtv.cms.portal.content.client.model.UiAsset;
import com.tandbergtv.cms.portal.content.client.model.UiField;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ColumnBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.label.LabelStringView;

public class TitleAssetColumn extends ColumnBase<String, AssetRecord> {

    public TitleAssetColumn(String name, String displayName) {
	super(name, displayName);
    }

    @Override
    public View<String> getView(AssetRecord record) {
	LabelStringView view = new LabelStringView("ERROR: Value not available");
	UiAsset uiAsset = record.getAsset();
	if (getName().equalsIgnoreCase("id")) {
	    view = new LabelStringView(Long.toString(uiAsset.getId()));
	} else if (getName().equalsIgnoreCase("type")) {
	    view = new LabelStringView(uiAsset.getType());
	} else {
	    for (UiField f : uiAsset.getFields()) {
		String colInternalName = TableColumnNameHelper.getColumnName(f.getName(), f
			.getParentAssetType());
		if (colInternalName.equals(getName())) {
		    view = new LabelStringView(f.getValue());
		}
		return view;
	    }
	}
	return view;
    }

}
