package com.tandbergtv.cms.portal.content.client.tab.list.assettable;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.cms.portal.content.client.model.UiAsset;
import com.tandbergtv.cms.portal.content.client.model.UiTable;
import com.tandbergtv.cms.portal.content.client.rpc.title.TitleSearchService;
import com.tandbergtv.cms.portal.content.client.rpc.title.TitleSearchServiceAsync;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UiColumn;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableConstants;

/**
 * Data Provider which helps the title asset list table population. It fetches
 * the column names, default sort column and order on initialization. Records
 * are fetched from the server when requested.
 * 
 * @author Daniel Silva
 * 
 */
public class TitleAssetDataProvider implements DataProvider<Long, AssetRecord> {

	private UiTable uiTable;

	private List<Column<?, AssetRecord>> columns;
	private List<UiColumn> uiColumns;

	private TitleRecord parentRecord;

	TitleSearchServiceAsync searchService = GWT.create(TitleSearchService.class);

	public TitleAssetDataProvider(TitleRecord parentRecord, UiTable uiTable) {
		this.parentRecord = parentRecord;
		this.uiTable = uiTable;
		initColumns();
	}

	private void initColumns() {
		columns = new ArrayList<Column<?, AssetRecord>>();
		uiColumns = uiTable.getColumns();
		if (uiColumns != null) {
			for (final UiColumn uiColumn : uiColumns) {
				String colInternalName = TableColumnNameHelper.getColumnName(uiColumn.getName(), null);
				TitleAssetColumn column = new TitleAssetColumn(colInternalName, uiColumn.getDisplayName());
				column.setCellStyle(getColumnCellStyle(uiColumn));
				columns.add(column);				
			}
		}

	}

	/*
	 * Determine the style to use based on the data type of the column data
	 */
	private String getColumnCellStyle(UiColumn column) {
		String style = TableConstants.STYLE_DATACELL_GENERAL;
		if (column.getDataType() != null) {
			switch (column.getDataType()) {
			case BOOLEAN:
			case STRING:
				style = TableConstants.STYLE_DATACELL_TEXT;
				break;
			case INTEGER:
			case FLOAT:
				style = TableConstants.STYLE_DATACELL_NUMERIC;
				break;
			case DATE:
			case TIME:
				style = TableConstants.STYLE_DATACELL_DATE;
				break;
			}
		}

		return style;
	}

	@Override
	public void initialize(final AsyncCallback<Void> callback) {
		callback.onSuccess(null);
	}

	@Override
	public List<Column<?, AssetRecord>> getColumns() {
		return columns;
	}

	@Override
	public void getRecord(Long key, AsyncCallback<AssetRecord> callback) {
		throw new UnsupportedOperationException();
	}

	@Override
	public void getRecords(final AsyncCallback<List<AssetRecord>> callback) {
		searchService.getAssetInfo(parentRecord.getKey(), uiTable.getColumns(),
				new NeptuneAsyncCallback<List<UiAsset>>() {

					@Override
					public void onNeptuneFailure(Throwable caught) {
						callback.onFailure(caught);
					}

					@Override
					public void onNeptuneSuccess(List<UiAsset> result) {
						List<AssetRecord> records = new ArrayList<AssetRecord>();
						for (UiAsset uiAsset : result) {
							records.add(new AssetRecord(uiAsset));
						}
						callback.onSuccess(records);
					}
				});
	}

	@Override
	public boolean isCheckboxEnabled() {
		return true;
	}

	@Override
	public boolean isRecordCountEnabled() {
		return false;
	}
}
