package com.tandbergtv.cms.portal.content.client.tab.list.assettable;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.cms.portal.content.client.i18n.ContentMessages;
import com.tandbergtv.cms.portal.content.client.model.NoPartnersException;
import com.tandbergtv.cms.portal.content.client.model.UISearchResult;
import com.tandbergtv.cms.portal.content.client.model.UISearchResultRec;
import com.tandbergtv.cms.portal.content.client.model.UiInvalidQwikSrchException;
import com.tandbergtv.cms.portal.content.client.rpc.title.TitleSearchService;
import com.tandbergtv.cms.portal.content.client.rpc.title.TitleSearchServiceAsync;
import com.tandbergtv.cms.portal.content.client.tab.list.TitleListPanel;
import com.tandbergtv.cms.portal.content.client.tab.search.SearchSpecialColumns;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UIFieldType;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UISortOrder;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilter;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UiColumn;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SortOrder;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.PageFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.SortFeatureImpl;

/**
 * Data Provider which helps the asset list table population. Records are
 * fetched from the server when requested.
 * 
 * @author spuranik
 */
public class UiAssetTableDataProvider implements DataProvider<Long, TitleRecord> {

	private TitleListPanel view;
	private List<UiColumn> uiColumns;
	private List<UiColumn> uiColumnsForQuery;
	private List<UiColumn> uiColumnsForExport;
	private List<Column<?, TitleRecord>> columns = new ArrayList<Column<?, TitleRecord>>();
	private SortOrder defaultSortOrder;
	private Column<?, TitleRecord> defaultSortColumn;
	private List<Column<?, TitleRecord>> sortableColumns = new ArrayList<Column<?,TitleRecord>>();
	
	private PageFeatureImpl pageFeature;
	private SortFeatureImpl<Long, TitleRecord> sortFeature;
	private int prevValidPageNumber = -1;
	private ContentMessages displayMessages = (ContentMessages) GWT.create(ContentMessages.class);
	
	public UiAssetTableDataProvider(TitleListPanel view) {
		this.view = view;
	}

	/**
	 * Sets all info it will need when making the query to fetch records.
	 * It also prepares the column view related in search results. This is weird!
	 */
	public void init(List<UiColumn> searchResultsColumns) {
		uiColumns = searchResultsColumns;
		uiColumnsForQuery = new ArrayList<UiColumn>();
		uiColumnsForExport = new ArrayList<UiColumn>();
		if (uiColumns != null) {
			for (final UiColumn uiColumn : uiColumns) {
				if (!(isThumbnailColumn(uiColumn))) {
					uiColumnsForQuery.add(uiColumn);
					uiColumnsForExport.add(uiColumn);
				}
			}
		}
	}

	/**
	 * Sets the list of display columns which has the underlying data. View for
	 * these columns also has been built somewhere else.
	 * 
	 * @param columns
	 */
	public void setDisplayColumns(List<Column<?, TitleRecord>> columns) {
		this.columns = columns;
	}
	
	/**
	 * Sets the list of display columns which has the underlying data. View for
	 * these columns also has been built somewhere else.
	 * 
	 * @param columns
	 */
	public void setSortColumns(List<Column<?, TitleRecord>> columns) {
		this.sortableColumns = columns;
	}

	public Column<?, TitleRecord> getDefaultSortColumn() {
		return defaultSortColumn;
	}
	
	public SortOrder getDefaultSortOrder() {
		return defaultSortOrder;
	}
	
	public List<Column<?, TitleRecord>> getSortableColumns() {
		return sortableColumns;
	}
	
	public void setPageFeature(PageFeatureImpl pageFeature) {
		this.pageFeature = pageFeature;
	}

	public void setSortFeature(SortFeatureImpl<Long, TitleRecord> sortFeature) {
		this.sortFeature = sortFeature;
	}

	@Override
	public void initialize(final AsyncCallback<Void> callback) {
		// using this method to resolve the fields for quick info column as this is an async call. 
		// if init were an async call, this could have been done there. Thats a neat way to do it.
		
		boolean quickInfoIsSelected = false;
		// get the individual fields for quick info
		for (final UiColumn uic : uiColumnsForQuery) {
			// if this is quick info column, add its individual fields and remove this from the list of query columns 
			if(isQuickInfoColumn(uic)) {
				QuickInfoColumnProvider qInfoProvider = QuickInfoColumnProvider.getInstance();
				NeptuneAsyncCallback<List<UiColumn>> fieldCallback = new NeptuneAsyncCallback<List<UiColumn>>() {

					@Override
					public void onNeptuneFailure(Throwable caught) {
						callback.onFailure(caught);
					}

					@Override
					public void onNeptuneSuccess(List<UiColumn> quickInfoColumns) {
						for(UiColumn c : quickInfoColumns) {
							c.setQuickInfoField(true);			
						}
						uiColumnsForQuery.addAll(quickInfoColumns);
						uiColumnsForQuery.remove(uic);
						
						// replace the fields in the export list to use these instead
						// all of this is being done to retain the order of columns when exporting
						int colPosition = uiColumnsForExport.indexOf(uic);
						List<UiColumn> remainingSelectedCols = new ArrayList<UiColumn>();
						if(colPosition < uiColumnsForExport.size() - 1) {
							remainingSelectedCols.addAll(uiColumnsForExport
									.subList(colPosition + 1, uiColumnsForExport.size()));
						}
						uiColumnsForExport.remove(colPosition);
						if(remainingSelectedCols.size() > 0) {
							uiColumnsForExport.removeAll(remainingSelectedCols);
						}
						uiColumnsForExport.addAll(quickInfoColumns);
						if(remainingSelectedCols.size() > 0) {
							uiColumnsForExport.addAll(remainingSelectedCols);
						}						
						
						callback.onSuccess(null);
					}
				};
				qInfoProvider.getColumns(fieldCallback);
				quickInfoIsSelected = true;
				break;
			}
		}
		
		// if quick info was not selected as one of the display columns so return back. 
		// There was nothing to initialize.
		if(!quickInfoIsSelected) {
			callback.onSuccess(null);
		}
	}

	@Override
	public List<Column<?, TitleRecord>> getColumns() {
		return columns;
	}

	@Override
	public void getRecord(Long key, AsyncCallback<TitleRecord> callback) {
		throw new UnsupportedOperationException();
	}

	@Override
	public void getRecords(final AsyncCallback<List<TitleRecord>> callback) {
		view.handleGetRecordsRequest();
		TitleSearchServiceAsync searchService = GWT.create(TitleSearchService.class);
		// get the search info from the passed in data, and then add sorting and
		// paging info
		UITitleFilter titleFilter = view.getTitleFilter();

		// set paging info
		titleFilter.getPageInfo().setStartIndex((pageFeature.getPageNumber() - 1) * pageFeature.getPageSize());
		titleFilter.getPageInfo().setMaxCount(pageFeature.getPageSize());

		// set sort info
		// TODO: Ideally the dp should be getting the sort column name and order. This should happen elsewhere 
		if (TableColumnNameHelper.isMetdataField(sortFeature.getSortColumnName())) {
			titleFilter.getSortInfo().setSortFieldType(UIFieldType.ASSET);
			String columnName = TableColumnNameHelper
					.getColumnName(sortFeature.getSortColumnName());
			titleFilter.getSortInfo().setSortColumnName(columnName);
			String colSection = TableColumnNameHelper
					.getSectionName(sortFeature.getSortColumnName()).toUpperCase();
			titleFilter.getSortInfo().setSortColumnSection(colSection);
		} else {
			titleFilter.getSortInfo().setSortFieldType(UIFieldType.PMM_TITLE);
			titleFilter.getSortInfo().setSortColumnName(sortFeature.getSortColumnName());
		}
		UISortOrder order = UISortOrder.DESCENDING;
		if(sortFeature.isAscending()) {
			order = UISortOrder.ASCENDING; 
		}
		titleFilter.getSortInfo().setSortOrder(order);

		// get matching titles
		searchService.getTitles(titleFilter, uiColumnsForQuery, new NeptuneAsyncCallback<UISearchResult>() {
			@Override
			public void onNeptuneFailure(Throwable caught) {
				pageFeature.setRecordCount(-1);
				if (caught instanceof NoPartnersException
								|| caught instanceof UiInvalidQwikSrchException) {
					callback.onSuccess(new ArrayList<TitleRecord>());
				} else {
					callback.onFailure(caught);
				}

				/* Also notify the view */
				view.handleGetRecordsFailureResponse(caught);
			}

			@Override
			public void onNeptuneSuccess(UISearchResult result) {
				List<TitleRecord> records = new ArrayList<TitleRecord>();
				
				// If the user had entered/navigated to a page with no
				// records, set it back to the current one and notify him
				if(result.getTitles() == null || result.getTitles().size() == 0) {
					if (prevValidPageNumber != -1) {
						int requestedPageNumber = pageFeature.getPageNumber();
						pageFeature.setPageNumber(prevValidPageNumber);
						view.hideBusyIndicator();
						Window.alert(displayMessages.noRecordsFound(requestedPageNumber));
						callback.onFailure(null);
						return;
					}
				}
				
				for (UISearchResultRec t : result.getTitles())
					records.add(new TitleRecord(t));
				pageFeature.setRecordCount(result.getTotalCount());
				pageFeature.setHasMorePages(result.isHasMoreResults());
				prevValidPageNumber = pageFeature.getPageNumber();
				callback.onSuccess(records);
				
				/* Also notify the view */
				view.handleGetRecordsSuccessResponse(records);
			}});
	}

	@Override
	public boolean isCheckboxEnabled() {
		return view.hasActions();
	}

	@Override
	public boolean isRecordCountEnabled() {
		return false;
	}
	
	public List<UiColumn> getExportColumns() {
		return uiColumnsForExport;
	}
	
	/* Determine if this is the thumbnail column */
	public static boolean isThumbnailColumn(UiColumn column) {
		return SearchSpecialColumns.THUMBNAIL_COLUMN.equals(column.getName());
	}
	
	/* Determine if this is the quick info column */
	public static boolean isQuickInfoColumn(UiColumn column) {
		return SearchSpecialColumns.QUICK_INFO_COLUMN.equals(column.getName());
	}
}
