package com.tandbergtv.cms.portal.content.client.tab.list.goButton;

import java.util.List;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.tandbergtv.cms.portal.content.client.i18n.ContentConstants;
import com.tandbergtv.cms.portal.content.client.i18n.ContentMessages;
import com.tandbergtv.cms.portal.content.client.tab.list.actionlist.ServiceMap;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IActionInput;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleActionService;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IView;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.OperationCompletedAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.PopupContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

/**
 * Action listener for title list operations.
 * 
 * @author spuranik
 * 
 */
public class ButtonClickListener implements ClickHandler {
	// list from which the selected operation is determined.
	private ListBoxWidget<String> list;
	
	// The selected item from this parameter list box will be passed when
	// invoking the execute api on the selected service.
	private ListBoxWidget<String> parameterList;

	// parent view from which title ids are extracted and to which control will
	// be returned in case of errors.
	private IView view;
	
	// map which contains the instances of service name -> service instance
	private ServiceMap serviceMap;

	private ContentConstants displayConstants = (ContentConstants) GWT.create(ContentConstants.class);
	private ContentMessages displayMessages = (ContentMessages) GWT.create(ContentMessages.class);
	
	public ButtonClickListener(ListBoxWidget<String> list,
			ListBoxWidget<String> parameterList, IView view, ServiceMap serviceMap) {
		this.list = list;
		this.parameterList = parameterList;
		this.view = view;
		this.serviceMap = serviceMap;
	}

	public void setParameterList (ListBoxWidget<String> parameterList) {
		this.parameterList = parameterList;
	}
	
	public void onClick(ClickEvent event) {
		int selectedIndex = list.getSelectedIndex();
		String displayName = list.getItemText(selectedIndex);

		ITitleActionService serviceImpl = serviceMap.getService(displayName);
		if (serviceImpl == null) {
			throw new RuntimeException("Service impl for : " + displayName + " could not be found.");
		}

		List<Long> ids = view.getSeletedRecordIds();

		// invoke the service to perform the operation. When the execution
		// returns back asynchronously, the service will be requested to go the
		// result page.

		// NOTE: In the meanwhile, the user can still work on the table. Should
		// the table be locked instead?
		OperationCompletedAsyncCallback callback = new OperationCompletedAsyncCallback(
				serviceImpl, this.view);
		// make sure at least one title has been selected
		if (ids.size() == 0) {
			callback.onFailure(new RuntimeException(displayConstants
					.atLeastOneTitleSelectionRequired()));
			return;
		}
		
		IActionInput input = view.getInputToExecution();
		
		// ask for a confirmation before executing - if the service needs it.
		if (serviceImpl.getConfirmation()) {
			view.show(false);
			getConfirmation(serviceImpl, ids, input, callback);
		} else {
		    serviceImpl.execute(ids, parameterList.getSelectedItem(), input, callback);
		}
	}

	/**
	 * Show the confirmation dialogue and only then proceed with the operation.
	 * 
	 * @param serviceImpl
	 * @param ids
	 * @param input
	 * @param callback
	 */
	protected void getConfirmation(final ITitleActionService serviceImpl,
			final List<Long> ids, final IActionInput input,
			final OperationCompletedAsyncCallback callback) {
		final PopupContainer confirmation = new PopupContainer(false, true);
		VerticalContainer popContainer = new VerticalContainer();
		
		popContainer.add(new LabelWidget(displayMessages.confirmationMessage(serviceImpl.getName())));
		HorizontalContainer buttonContainer = new HorizontalContainer();
		
		// yes button
		ButtonWidget yesButton = new ButtonWidget(displayConstants.confirmationYes());
		yesButton.addStyleDependentName(StyleNames.COMMIT_BUTTON_STYLE);
		yesButton.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				// ask the view to enable any controls
				view.show(true);
				confirmation.hide();
				StringBuilder parmList = new StringBuilder();
				boolean isFirst = true;
				if (parameterList.isMultipleSelect() == true) {
					for (int i = 0, l = parameterList.getItemCount(); i < l; i++) {
						if (parameterList.isItemSelected(i)) {
							String selectedParameter = parameterList.getItemText(i);
							if (isFirst == false)
								parmList.append(",");
							else
								isFirst = false;
							parmList.append(selectedParameter);
						}
					}	
					
					serviceImpl.execute(ids, parmList.toString(), input, callback);
				}
				else
					serviceImpl.execute(ids, parameterList.getSelectedItem(), input, callback);
			}
		});
		buttonContainer.add(yesButton);
		
		// no button
		ButtonWidget noButton = new ButtonWidget(displayConstants.confirmationNo());
		noButton.addStyleDependentName(StyleNames.DATALOSS_BUTTON_STYLE);
		noButton.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				// ask the view to enable any controls
				view.show(true);
				view.show(displayConstants.cancelledOperation());
				confirmation.hide();
			} });
		buttonContainer.add(noButton);
		
		popContainer.add(buttonContainer);
		popContainer.setCellHorizontalAlignment(buttonContainer, VerticalContainer.ALIGN_CENTER);
		confirmation.add(popContainer);
		confirmation.center();
		confirmation.show();
	}
	
	/* ---------- SETTERS AND GETTERS ---------- */

	/**
	 * @return the list
	 */
	protected ListBoxWidget<String> getList() {
	    return list;
	}

	/**
	 * @param list the list to set
	 */
	protected void setList(ListBoxWidget<String> list) {
	    this.list = list;
	}

	/**
	 * @return the view
	 */
	protected IView getView() {
	    return view;
	}

	/**
	 * @param view the view to set
	 */
	protected void setView(IView view) {
	    this.view = view;
	}

	/**
	 * @return the serviceMap
	 */
	protected ServiceMap getServiceMap() {
	    return serviceMap;
	}

	/**
	 * @param serviceMap the serviceMap to set
	 */
	protected void setServiceMap(ServiceMap serviceMap) {
	    this.serviceMap = serviceMap;
	}

	/**
	 * @return the displayConstants
	 */
	protected ContentConstants getDisplayConstants() {
	    return displayConstants;
	}

	/**
	 * @param displayConstants the displayConstants to set
	 */
	protected void setDisplayConstants(ContentConstants displayConstants) {
	    this.displayConstants = displayConstants;
	}

	/**
	 * @return the displayMessages
	 */
	protected ContentMessages getDisplayMessages() {
	    return displayMessages;
	}

	/**
	 * @param displayMessages the displayMessages to set
	 */
	protected void setDisplayMessages(ContentMessages displayMessages) {
	    this.displayMessages = displayMessages;
	}

	/**
	 * @return the parameterList
	 */
	protected ListBoxWidget<String> getParameterList() {
	    return parameterList;
	}
}
