package com.tandbergtv.cms.portal.content.client.tab.list.goButton;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.google.gwt.event.dom.client.ClickEvent;
import com.tandbergtv.cms.portal.content.client.tab.list.TitleListPanel;
import com.tandbergtv.cms.portal.content.client.tab.list.actionlist.ServiceMap;
import com.tandbergtv.cms.portal.content.client.tab.list.assettable.TitleRecord;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IActionInput;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleActionService;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleAssetActionService;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.OperationCompletedAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ExpandingProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Record;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.ExpandingFeature;

/**
 * Action listener for title list operations.
 * 
 * @author spuranik
 * 
 */
public class TitleListButtonClickListener extends ButtonClickListener {
    	
    	private TitleListPanel titleListPanel;
    
	public TitleListButtonClickListener(ListBoxWidget<String> list,
			ListBoxWidget<String> parameterList, TitleListPanel view, ServiceMap serviceMap) {
		super(list, parameterList, view, serviceMap);
		this.titleListPanel = view;
	}
	
	public void onClick(ClickEvent event) {
		int selectedIndex = getList().getSelectedIndex();
		String displayName = getList().getItemText(selectedIndex);

		ITitleActionService serviceImpl = getServiceMap().getService(displayName);
		if (serviceImpl == null) {
			throw new RuntimeException("Service impl for : " + displayName + " could not be found.");
		}

		List<Long> ids = new ArrayList<Long>();
		List<TitleRecord> selectedIds = titleListPanel.getAssetTable().getSelectedRecords();
		for (TitleRecord tr : selectedIds) {
		    ids.add(tr.getKey());
		}
		
		// invoke the service to perform the operation. When the execution
		// returns back asynchronously, the service will be requested to go the
		// result page.

		// NOTE: In the meanwhile, the user can still work on the table. Should
		// the table be locked instead?
		OperationCompletedAsyncCallback callback = new OperationCompletedAsyncCallback(
				serviceImpl, this.getView());
		// make sure at least one title has been selected
		if (serviceImpl.needTitlesTobeSelected() && ids.size() == 0) {
			callback.onFailure(new RuntimeException(getDisplayConstants()
					.atLeastOneTitleSelectionRequired()));
			return;
		}
		
		IActionInput input = getView().getInputToExecution();
		
		if ( serviceImpl instanceof ITitleAssetActionService ) {
			Map<Long,List<Long>> titleAssetIdsMap = getTitleAssetIdsMap();
		    ((ITitleAssetActionService) serviceImpl).executeAddAssets(titleAssetIdsMap, getParameterList().getSelectedItem(), input, callback);
		} else if (serviceImpl.getConfirmation()) { // ask for a confirmation before executing - if the service needs it.
		    getView().show(false);
		    getConfirmation(serviceImpl, ids, input, callback);
		} else {
		    serviceImpl.execute(ids, getParameterList().getSelectedItem(), input, callback);
		}
	}

	private Map<Long,List<Long>> getTitleAssetIdsMap() {
		Map<Long,List<Long>> titleAssetIdsMap = new HashMap<Long, List<Long>>();
    
    	ExpandingFeature<Long, TitleRecord> expandingFeature = titleListPanel.getAssetTable().getExpandingFeature();
    	if (expandingFeature != null) {
    	    ExpandingProvider<Long, TitleRecord, ?, ? extends Record<?>> expandingProvider = expandingFeature.getExpandingProvider();
    	    List<TitleRecord> titlesList = titleListPanel.getAssetTable().getRecords();
    	    for (TitleRecord titleRecord : titlesList) {
        		List<? extends Record<?>> selectedIdsByParent = expandingProvider.getSelectedRecords(titleRecord);
        		for (Record<?> r : selectedIdsByParent) {
        		    storeNewPair( titleAssetIdsMap, titleRecord.getKey(), ((Record<Long>) r).getKey() );
        		}
    	    }
    	}
    	return titleAssetIdsMap;
    }
	
	private void storeNewPair( Map<Long,List<Long>> titleAssetIdsMap, Long titleId, Long assetId) {
		List<Long> assetIdsList = titleAssetIdsMap.get( titleId );
		if ( assetIdsList == null ) {
			assetIdsList = new ArrayList<Long>(1);
			titleAssetIdsMap.put( titleId, assetIdsList );
		}
		assetIdsList.add( assetId );
	}

}
