package com.tandbergtv.cms.portal.content.client.tab.search;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.SimplePanel;
import com.tandbergtv.cms.portal.content.client.exception.BasicSearchFieldValidationException;
import com.tandbergtv.cms.portal.content.client.rpc.title.ITitleBasicSearchFieldProvider;
import com.tandbergtv.cms.portal.content.client.rpc.title.ITitleBasicSearchFieldProviderAsync;
import com.tandbergtv.cms.portal.ui.title.client.TitleConstants;
import com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.AssetFieldTreeObject;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.PMMFieldProvider;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.UIDataType;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.UiBasicSearchField;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.RHSDateRangeWidget;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.RHSValueWidget;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.SimpleRHSValueWidget;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.ValueBooleanBox;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.ValueTextBox;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.validate.FloatValidator;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.validate.LongValidator;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.validate.StringValidator;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.validate.TimeValidator;
import com.tandbergtv.cms.portal.ui.title.client.model.search.BaseOperator;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilterValueNode;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.option.UIValueOption;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.messagearea.MessageArea;

public class BasicSearchRow extends HorizontalPanel {
	private TitleConstants myConstants = (TitleConstants) GWT
			.create(TitleConstants.class);

	private List<UiBasicSearchField> searchFieldsCache = null;
	private ListBoxWidget<UiBasicSearchField> searchFields;
	private UiBasicSearchField currentSearchField;
	private Label operatorLabel;
	private SimplePanel valueContainer;
	private MessageArea messageArea;
	
	
	public BasicSearchRow(final UiCriteriaMode criteriaMode) {
		ITitleBasicSearchFieldProviderAsync sfp = GWT.create(ITitleBasicSearchFieldProvider.class);
		sfp.getBasicSearcFields(criteriaMode, new NeptuneAsyncCallback<List<UiBasicSearchField>>() {

			@Override
			public void onNeptuneFailure(Throwable caught) {
				if(caught instanceof BasicSearchFieldValidationException){
					buildUi(criteriaMode);
					messageArea.setErrorMessage(caught.getMessage());
				}
				
				
			}

			@Override
			public void onNeptuneSuccess(List<UiBasicSearchField> result) {
				searchFieldsCache = result;
				buildUi(criteriaMode);
			}
			
		});
		setSpacing(3);
	}

	private void buildUi(UiCriteriaMode critMode ) {
		boolean isSeries = isSeries();
		searchFields = new ListBoxWidget<UiBasicSearchField>();
		//take care of the PMM title fields
		List<UiBasicSearchField> pmmFields = PMMFieldProvider.getBasicSearchFields(critMode);
		for (UiBasicSearchField sf : pmmFields) {
			//for series do not include content class
			if(!(isSeries && sf.getXpath().equalsIgnoreCase("contentClassId")) ) {
				searchFields.addItem(sf.getDisplayName(), sf);
			}
		}
		String complexFieldStr = "";
		//take care of the mdm spec fields
		if( searchFieldsCache != null) {
			for (UiBasicSearchField sf : searchFieldsCache) {
				if(!sf.isComplex()) {
					searchFields.addItem(sf.getDisplayName(), sf);
				}
				else {
					if(!complexFieldStr.isEmpty()) {
						complexFieldStr = complexFieldStr + " ,  " + (sf.getXpath());
					}
					else {
						complexFieldStr = complexFieldStr + "  " + (sf.getXpath());
					}
				}
			}
		}
		if(!complexFieldStr.isEmpty()) {
			messageArea.setErrorMessage("Complex field defined in configuration file: " + complexFieldStr);
		}
		currentSearchField = searchFields.getSelectedItem();
		searchFields.addChangeHandler(getSearchFieldsChangeHandler());
		add(searchFields);

		operatorLabel = new Label(myConstants.getString(currentSearchField
				.getDefaultOperator().toString()));
		operatorLabel.setWidth("70px");
		valueContainer = new SimplePanel();
		valueContainer.setWidget(getValueWidget(""));
		add(operatorLabel);
		setCellHorizontalAlignment(operatorLabel, BasicSearchRow.ALIGN_CENTER);
		setCellVerticalAlignment(operatorLabel, BasicSearchRow.ALIGN_MIDDLE);
		add(valueContainer);
		add(buildRemoveButton());
	}
	
	private boolean isSeries() {
		if(searchFieldsCache != null) {
			for(UiBasicSearchField searchField: searchFieldsCache) {
				if (searchField.getAssetType().equalsIgnoreCase("series")) {
					return true;
				}
			}
		}
		return false;
	}

	public HandlerRegistration addBasicSearchRowHandler(BasicSearchRowHandler handler) {
		return addHandler(handler, BasicSearchRowEvent.TYPE);
	}

	private Button buildRemoveButton() {
		return new Button("-", new ClickHandler() {

			@Override
			public void onClick(ClickEvent event) {
				fireEvent(new BasicSearchRowEvent(BasicSearchRow.this));
			}

		});

	}

	public boolean validate() {
		return ((RHSValueWidget)valueContainer.getWidget()).validate();
	}

	public UITitleFilterValueNode getValue() {
		UiBasicSearchField selectedItem = searchFields.getSelectedItem();
		UIDataType dataType = selectedItem.getDatatype();
		List<String> value = ((RHSValueWidget)valueContainer.getWidget()).getValues();
		BaseOperator operator = selectedItem.getDefaultOperator();
		if(operatorLabel.getText().equals(myConstants.equal())){
			operator = BaseOperator.EQUAL;
		}
		
		return new UITitleFilterValueNode(selectedItem.getXpath(),
				selectedItem.getAssetType(), selectedItem.getFieldType(),
				operator, value, operator.getParamType(), false, false,
				dataType, "", "", "");
	}

	private ChangeHandler getSearchFieldsChangeHandler() {
		return new ChangeHandler() {

			@Override
			public void onChange(ChangeEvent event) {
				UiBasicSearchField si = searchFields.getSelectedItem();
				BaseOperator operator = si.getDefaultOperator();

				//get suggested values when applicable
				boolean newItemHasSuggested = hasSuggestedValues(si); 
				if(newItemHasSuggested) 
					operator = BaseOperator.EQUAL;

				if (!si.getDatatype().equals(currentSearchField.getDatatype())
						|| newItemHasSuggested || hasSuggestedValues(currentSearchField)) {
					
					operatorLabel.setText(myConstants.getString(operator.toString()));
					valueContainer.setWidget(getValueWidget(""));
				}
				currentSearchField = si;
			}
		};
	}

	private boolean hasSuggestedValues(UiBasicSearchField field) {
		return field.getSuggestedValues() != null || getSuggestedValues(field) != null;
	}
	
	private Map<String, String> getSuggestedValuesMap(UiBasicSearchField field) {
		UIDataType dataType = field.getDatatype();
		//get suggested values when applicable
		if (dataType.equals(UIDataType.STRING)
				|| dataType.equals(UIDataType.INTEGER)
				|| dataType.equals(UIDataType.FLOAT)) {
			if (AssetFieldTreeObject.getFieldOptions() != null) {
				return AssetFieldTreeObject.getFieldOptions().get(
						field.getXpath());
			}
		}
		return null;
	}
	
	private List<UIValueOption> getSuggestedValues(UiBasicSearchField field) {
		if(field.getSuggestedValues() != null)
			return field.getSuggestedValues();
		List<UIValueOption> uiOptions = new ArrayList<UIValueOption>();
		Map<String, String> suggValues = getSuggestedValuesMap(field);
		if(suggValues == null)
			return null;
		for(Entry<String, String> option : suggValues.entrySet()) {
			uiOptions.add(new UIValueOption(option.getValue(), option.getKey()));
		}
		return uiOptions;
	}

	private RHSValueWidget getValueWidget(String oldValue) {
		// The logic here is much simplier than that used in the advanced search
		// & rules. No special cases. Only supports simple data types.
		UiBasicSearchField field = searchFields.getSelectedItem();
		UIDataType dataType = field.getDatatype();
		List<UIValueOption> suggestedValues = getSuggestedValues(field);
		if (suggestedValues != null)
			return new SimpleRHSValueWidget(new ValueTextBox(
					new StringValidator(), suggestedValues, field.supportsOther()));
		switch(dataType) {
		case INTEGER:
			return new SimpleRHSValueWidget(new ValueTextBox(
					new LongValidator()));
		case FLOAT:
			return new SimpleRHSValueWidget(new ValueTextBox(
					new FloatValidator()));
		case BOOLEAN:
			return new SimpleRHSValueWidget(new ValueBooleanBox());
		case DATE:
			return new RHSDateRangeWidget();
		case TIME:
			return new SimpleRHSValueWidget(new ValueTextBox(new TimeValidator()));
		default:
			return new SimpleRHSValueWidget(new ValueTextBox(new StringValidator()));
		}
	}

	public MessageArea getMessageArea() {
		return messageArea;
	}

	public void setMessageArea(MessageArea messageArea) {
		this.messageArea = messageArea;
	}

}
