/**
 * File Name	:	ComplexHeaderPanel.java
 * Created By	:	Sanjay Khattar (sanjay.khattar@ericsson.com)
 * Date Created	:	Oct 1, 2012 6:20:23 PM
 * Purpose		:	
 *
 * (c) Ericsson Television Inc. 
 */
package com.tandbergtv.cms.portal.content.client.tab.search;

import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

/**
 * @author esakhat (sanjay.khattar@ericsson.com)
 *
 */
public class ComplexHeaderPanel extends Composite {

	private static final String STYLE_COMPLEX_HEADER_PANEL = "complex-header-panel";
	private static final String STYLE_HEADER_DESCRIPTION = "complex-header-description";
	private static final String STYLE_HEADER_SUB_DESCRIPTION = "complex-header-sub-description";
	private static final String STYLE_HEADER_TIP = "complex-header-tip";
	private static final String STYLE_HEADER_CAUTION = "complex-header-caution";
	private static final String STYLE_HEADER_NOTE = "complex-header-note";

	private SimpleContainer mainContainer;
	private VerticalContainer container;

	/**
	 * 
	 */
	public ComplexHeaderPanel() {
		mainContainer = new SimpleContainer();
		initWidget(mainContainer);

		container = new VerticalContainer();
		container.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
		mainContainer.setWidget(container);

		this.setStyleName(STYLE_COMPLEX_HEADER_PANEL);
	}

	public void addHeaderDescription(String headerDescription) {
		LabelWidget headerDescriptionLabel = new LabelWidget(headerDescription);
		headerDescriptionLabel.setStyleName(STYLE_HEADER_DESCRIPTION);
		container.add(headerDescriptionLabel);
	}
	
	public void addHeaderSubDescription(String headerSubDescription) {
		LabelWidget headerSubDescriptionLabel = new LabelWidget(headerSubDescription);
		headerSubDescriptionLabel.setStyleName(STYLE_HEADER_SUB_DESCRIPTION);
		container.add(headerSubDescriptionLabel);
	}
	
	public void addHeaderTip(String headerTip) {
		LabelWidget headerTipLabel = new LabelWidget(headerTip);
		headerTipLabel.setStyleName(STYLE_HEADER_TIP);
		container.add(headerTipLabel);
	}
	
	public void addHeaderCaution(String headerCaution) {
		LabelWidget headerCautionLabel = new LabelWidget(headerCaution);
		headerCautionLabel.setStyleName(STYLE_HEADER_CAUTION);
		container.add(headerCautionLabel);
	}
	
	public void addHeaderNote(String headerNote) {
		LabelWidget headerNoteLabel = new LabelWidget(headerNote);
		headerNoteLabel.setStyleName(STYLE_HEADER_NOTE);
		container.add(headerNoteLabel);
	}
	
}
