package com.tandbergtv.cms.portal.content.client.tab.search;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.i18n.ContentConstants;
import com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UIFieldType;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilter;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilterListNode;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.messagearea.MessageArea;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

public class NewBasicSearchPanel extends VerticalPanel {
	private static final String STYLE_BASIC_SEARCH_PANEL = "basic-search-panel";
	
	private ContentConstants myConstants = (ContentConstants)GWT.create(ContentConstants.class);

	private VerticalPanel basicSearchRows;
	private Button search;
	private SearchColumnPanel searchColumnPanel;
	private MessageArea messageArea;

	private UiCriteriaMode criteriaMode;

	public NewBasicSearchPanel(SearchColumnPanel searchColumnPanel, UiCriteriaMode criteriaMode, MessageArea messageArea) {
		this.criteriaMode = criteriaMode;
		this.messageArea = messageArea;
		ComplexHeaderPanel complexHeaderPanel = buildComplexHeaderPanel();
		add(complexHeaderPanel);
		basicSearchRows = new VerticalPanel();
		addDefaultRow(messageArea);
		add(basicSearchRows);
		search = buildSearchButton();
		add(buildAddButton());
		HorizontalPanel buttonPanel = new HorizontalPanel();
		buttonPanel.add(search);
		add(buttonPanel);
		addStyleName(STYLE_BASIC_SEARCH_PANEL);
		this.searchColumnPanel = searchColumnPanel;
	}


	private Button buildAddButton() {
		return new Button("+", new ClickHandler() {

			@Override
			public void onClick(ClickEvent event) {
				BasicSearchRow newRow = new BasicSearchRow(criteriaMode);
				newRow.addBasicSearchRowHandler(getRowHandler());
				basicSearchRows.add(newRow);
			}

		});

	}
	
	private void addDefaultRow(MessageArea messageArea) {
		BasicSearchRow defaultRow = new BasicSearchRow(criteriaMode);
		defaultRow.setMessageArea(messageArea);
		defaultRow.addBasicSearchRowHandler(getRowHandler());
		basicSearchRows.add(defaultRow);
	}

	private BasicSearchRowHandler getRowHandler() {
		return new BasicSearchRowHandler() {
			
			@Override
			public void handleRowRemove(BasicSearchRow rowToRemove) {
				basicSearchRows.remove(rowToRemove);
				if(basicSearchRows.getWidgetCount() == 0) {
					addDefaultRow(messageArea);
				}
			}
			
		};
	}

	/**
	 * registers a handler for the event thrown when a basic search is initiated.
	 * @param handler
	 * @return
	 */
	public HandlerRegistration addTitleSearchHandler(TitleSearchHandler handler) {
		return addHandler(handler, TitleSearchEvent.TYPE);
	}

	private Button buildSearchButton() {
		Button searchButton = new Button(myConstants.searchButtonName(), new ClickHandler() {

			@Override
			public void onClick(ClickEvent event) {
				// and is default for the list and that is what I want.

				boolean isValid = true;
				UITitleFilterListNode list = new UITitleFilterListNode();
				for (Widget w : basicSearchRows) {
					BasicSearchRow row = (BasicSearchRow) w;
					if (!row.validate())
						isValid = false;
					else {
						list.addItem(row.getValue());
						try {
							searchColumnPanel.validateSelections();
						} catch(SelectionValidationException e) {
							isValid = false;
							searchColumnPanel.showErrorMessage(e.getMessage());
						}
					}
				}
				if (isValid) {
					UITitleFilter filter = new UITitleFilter();
					filter.setCriteriaMode(criteriaMode);
					filter.setRootNode(list);
					filter.setIncludeCount(true);
					setFilterSortInfo(filter);
					TitleSearchEvent searchEvent = new TitleSearchEvent(filter, searchColumnPanel.getSelectedColumns());
					fireEvent(searchEvent);
				} else {
					// TODO display a message
				}
			}

		});
		
		searchButton.addStyleDependentName(StyleNames.DO_BUTTON_STYLE);
		
		return searchButton;
	}
	
	public void reset() {
		basicSearchRows.clear();
		addDefaultRow(messageArea);
	}

	private void setFilterSortInfo(UITitleFilter filter) {
		if(searchColumnPanel.getSelectedSortColumn().getFieldType().equals(UIFieldType.ASSET)) {
			filter.getSortInfo().setSortFieldType(UIFieldType.ASSET);
			filter.getSortInfo().setSortColumnSection(searchColumnPanel.getSelectedSortColumn().getSectionName());
		} else {
			filter.getSortInfo().setSortFieldType(UIFieldType.PMM_TITLE);
		}
		filter.getSortInfo().setSortColumnName(searchColumnPanel.getSelectedSortColumn().getName());
		filter.getSortInfo().setSortOrder(searchColumnPanel.getSelectedSortOrder());
	}
	
	private ComplexHeaderPanel buildComplexHeaderPanel() {
		ComplexHeaderPanel complexHeaderPanel = new ComplexHeaderPanel();
		complexHeaderPanel.addHeaderDescription(myConstants.basicSearchHeaderDescription());
		complexHeaderPanel.addHeaderCaution(myConstants.basicSearchCaution());
		complexHeaderPanel.addHeaderTip(myConstants.basicSearchTip());
		
		return complexHeaderPanel;
	}

}
