/**
 * File Name	:	QuickSearchPanel.java
 * Created By	:	Sanjay Khattar (sanjay.khattar@ericsson.com)
 * Date Created	:	Sep 12, 2012 6:09:04 PM
 * Purpose		:	
 *
 * (c) Ericsson Television Inc. 
 */
package com.tandbergtv.cms.portal.content.client.tab.search;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.core.client.Scheduler.ScheduledCommand;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.user.client.ui.TextBox;
import com.tandbergtv.cms.portal.content.client.i18n.ContentConstants;
import com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UIFieldType;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilter;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilterQuickSearch;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

/**
 * @author esakhat (sanjay.khattar@ericsson.com)
 *
 */
public class QuickSearchPanel extends SearchPanelBase {

	private static final String STYLE_QUICK_SEARCH_PANEL = "quick-search-panel";
	
	private VerticalContainer verticalContainer;
	private HorizontalContainer horizontalContainer;
	private TextBox quickSearchBox;

	private ContentConstants contentConstants = (ContentConstants) GWT.create(ContentConstants.class);

	/**
	 * 
	 */
	public QuickSearchPanel(NeptuneSecurity neptuneSecurity, UiCriteriaMode criteriaMode) {
		this(null, neptuneSecurity, criteriaMode);
	}

	/**
	 * 
	 */
	public QuickSearchPanel(SearchColumnPanel searchColumnPanel, NeptuneSecurity neptuneSecurity, UiCriteriaMode criteriaMode) {
		super(searchColumnPanel, neptuneSecurity, criteriaMode);
		
		verticalContainer = new VerticalContainer();

		ComplexHeaderPanel complexHeaderPanel = buildComplexHeaderPanel();
		verticalContainer.add(complexHeaderPanel);

		horizontalContainer = new HorizontalContainer();
		horizontalContainer.setSpacing(10);
		horizontalContainer.add(buildQuickSearchBox());
		horizontalContainer.add(buildQSGoButton());
		
		verticalContainer.addStyleName(STYLE_QUICK_SEARCH_PANEL);
		verticalContainer.add(horizontalContainer);
		
		initWidget(verticalContainer);
		
	}

	public void resetFocus() {
		Scheduler.get().scheduleDeferred(new ScheduledCommand() {

			@Override
			public void execute() {
				quickSearchBox.setFocus(true);
			}
			
		});
	}
	
	/*
	 * This builds the quick search text box. The thingy you enter your text for
	 * the quick search.
	 */
	private TextBox buildQuickSearchBox() {
		quickSearchBox = new TextBox();
		quickSearchBox.setWidth("325px");
		quickSearchBox.setMaxLength(255);
		quickSearchBox.addKeyDownHandler(new KeyDownHandler() {

			@Override
			public void onKeyDown(KeyDownEvent event) {
				if (event.getNativeKeyCode() == 13) {
					performQuickSearch();
				}
			}

		});
		return quickSearchBox;
	}

	private void performQuickSearch() {
		String value = quickSearchBox.getValue().trim();
		if (value.isEmpty()) {
			showErrorMessage(contentConstants.qsEmptyErr());
			return;
		}

		//must either be wrapped in quotes
		UITitleFilter filter = new UITitleFilter();
		filter.setCriteriaMode(criteriaMode);
		setFilterSortInfo(filter);
		filter.setRootNode(new UITitleFilterQuickSearch(value));
		TitleSearchEvent searchEvent = new TitleSearchEvent(filter, getSelectedSearchResultsColumns());
		fireEvent(searchEvent);
	}

	/*
	 * builds the Quick search Go button. The thingy you click to perform your
	 * quick search.
	 */
	private ButtonWidget buildQSGoButton() {
		ButtonWidget qsGoButton = new ButtonWidget(contentConstants.goButton());
		qsGoButton.addClickHandler(new ClickHandler() {

			@Override
			public void onClick(ClickEvent event) {
				if(validate())
				performQuickSearch();
			}

		});
		qsGoButton.addStyleDependentName(StyleNames.DO_BUTTON_STYLE);
		return qsGoButton;
	}

	private void setFilterSortInfo(UITitleFilter filter) {
		if(getSelectedSortColumn().getFieldType().equals(UIFieldType.ASSET)) {
			filter.getSortInfo().setSortFieldType(UIFieldType.ASSET);
			filter.getSortInfo().setSortColumnSection(getSelectedSortColumn().getSectionName());
		} else {
			filter.getSortInfo().setSortFieldType(UIFieldType.PMM_TITLE);
		}
		filter.getSortInfo().setSortColumnName(getSelectedSortColumn().getName());
		filter.getSortInfo().setSortOrder(getSelectedSortOrder());
	}

	private ComplexHeaderPanel buildComplexHeaderPanel() {
		ComplexHeaderPanel complexHeaderPanel = new ComplexHeaderPanel();
		complexHeaderPanel.addHeaderDescription(contentConstants.quickSearchHeaderDescription());
		complexHeaderPanel.addHeaderCaution(contentConstants.quickSearchCaution());
		complexHeaderPanel.addHeaderTip(contentConstants.quickSearchTip());
		
		return complexHeaderPanel;
	}

}
