/**
 * File Name	:	SearchPanelBase.java
 * Created By	:	Sanjay Khattar (sanjay.khattar@ericsson.com)
 * Date Created	:	Sep 12, 2012 6:14:49 PM
 * Purpose		:	
 *
 * (c) Ericsson Television Inc. 
 */
package com.tandbergtv.cms.portal.content.client.tab.search;

import java.util.List;

import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.Composite;
import com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UISortOrder;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UiColumn;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UiSortInfo;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.resizablecontainer.IMessageEmitter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.resizablecontainer.IMessageListener;

/**
 * @author esakhat (sanjay.khattar@ericsson.com)
 *
 */
public class SearchPanelBase extends Composite implements IMessageEmitter {

	protected NeptuneSecurity neptuneSecurity;
	protected UiCriteriaMode criteriaMode;
	protected IMessageListener messageListener;

	protected SearchColumnPanel searchColumnPanel;
	protected SearchTabPanel searchTabPanel;
	
	public SearchPanelBase(NeptuneSecurity neptuneSecurity, UiCriteriaMode criteriaMode) {
		this(null, neptuneSecurity, criteriaMode);
	}

	/**
	 * 
	 */
	public SearchPanelBase(SearchColumnPanel searchColumnPanel, NeptuneSecurity neptuneSecurity, UiCriteriaMode criteriaMode) {
		this.searchColumnPanel = searchColumnPanel;
		this.neptuneSecurity = neptuneSecurity;
		this.criteriaMode = criteriaMode;
		
	}

	@Override
	public void registerMessageListener(IMessageListener messageListener) {
		this.messageListener = messageListener;
	}
	
	public void showInfoMessage(String infoMsg) {
		if (messageListener != null) {
			messageListener.setInfoMessage(infoMsg);
		}
	}
	
	public void showErrorMessage(String errorMessage) {
		if (messageListener != null) {
			messageListener.setErrorMessage(errorMessage);
		}
	}
	
	public void resetMessageListener() {
		if (messageListener != null) {
			messageListener.reset();
		}
	}

	public List<UiColumn> getDisplayColumns() {
		return searchColumnPanel.getSearchResultColumns();
	}

	public List<UiColumn> getSelectedSearchResultsColumns() {
		return searchColumnPanel.getSelectedColumns();
	}

	public UiColumn getSelectedSortColumn() {
		return searchColumnPanel.getSelectedSortColumn();
	}
	
	public UISortOrder getSelectedSortOrder() {
		return searchColumnPanel.getSelectedSortOrder();
	}
	
	public UiColumn getSortColumn(UiSortInfo partialSortInfo) {
		return searchColumnPanel.getUiColumnForSavedSortColumn(partialSortInfo);
	}

	public HandlerRegistration addTitleSearchHandler(TitleSearchHandler handler) {
		return addHandler(handler, TitleSearchEvent.TYPE);
	}
	
	protected SearchTabPanel getSearchTabPanel() {
		return this.searchTabPanel;
	}
	
	protected void setSearchTabPanel(SearchTabPanel searchTabPanel) {
		this.searchTabPanel = searchTabPanel;
	}
	
	public String getCurrentUser() {
		return neptuneSecurity.getUsername();
	}

	public boolean validate() {
		boolean isValid = false;
		try {
			searchColumnPanel.validateSelections();
			isValid = true;
		} catch(SelectionValidationException e) {
			searchColumnPanel.showErrorMessage(e.getMessage());
		}	
		return isValid;
	}
}
