/**
 * File Name	:	SearchResultsPanel.java
 * Created By	:	Sanjay Khattar (sanjay.khattar@ericsson.com)
 * Date Created	:	Aug 29, 2012 5:40:04 PM
 * Purpose		:	
 *
 * (c) Ericsson Television Inc. 
 */
package com.tandbergtv.cms.portal.content.client.tab.search;

import java.util.List;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.core.client.Scheduler.ScheduledCommand;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Composite;
import com.tandbergtv.cms.portal.content.client.i18n.ContentConstants;
import com.tandbergtv.cms.portal.content.client.model.UiServiceItem;
import com.tandbergtv.cms.portal.content.client.services.title.RunNormalizationRuleService;
import com.tandbergtv.cms.portal.content.client.tab.list.TitleListPanel;
import com.tandbergtv.cms.portal.content.client.tab.list.actionlist.ActionListDataProvider;
import com.tandbergtv.cms.portal.content.client.tab.list.actionlist.ServiceMap;
import com.tandbergtv.cms.portal.content.client.tab.list.goButton.TitleListButtonClickListener;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleActionService;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleService;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneApplication;
import com.tandbergtv.neptune.widgettoolkit.client.application.ServiceLoader;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.resizablecontainer.IResizable;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.resizablecontainer.ResizableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.ViewCancelEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;
import com.google.gwt.user.client.ui.Image;

/**
 * @author esakhat (sanjay.khattar@ericsson.com)
 *
 */
public class SearchResultsPanel extends Composite {

	private static final String STYLE_NAME_SEARCH_RESULTS_PANEL = "search-results-panel";

	private VerticalContainer mainContainer;
	HeaderPanel headerPanel;
	private TitleListPanel titleListPanel;
	private boolean isSeries;

	private ButtonWidget goButton;
	private ButtonWidget cancelButton;
	private ListBoxWidget<String> actionsListBox;
	private ListBoxWidget<String> parameterListBox;
	private ListBoxWidget<String> multiSelectParameterListBox;

	TitleListButtonClickListener actionButtonHandler = null;
	boolean useMultiSelectParameters=false;

	// map for services
	private ServiceMap serviceMap = new ServiceMap();

	private ServiceLoader serviceLoader;

	private ContentConstants contentConstants = (ContentConstants) GWT.create(ContentConstants.class);

	/**
	 * 
	 */
	public SearchResultsPanel(final TitleListPanel titleListPanel, boolean isSeries) {
		this.titleListPanel = titleListPanel;
		this.isSeries = isSeries;
		
		this.serviceLoader = NeptuneApplication.getApplication().getServiceLoader();

		if (!isSeries) {
			headerPanel = new HeaderPanel(contentConstants.advancedSearchLabel());
			headerPanel.setImage(new Image("cms_contentmgmt_ui/resources/images/ico_content.png"));
		}
		else {
			headerPanel = new HeaderPanel(contentConstants.seriesAdvancedSearchLabel());
			headerPanel.setImage(new Image("cms_contentmgmt_ui/resources/images/ico_content.png"));
		}
		
		String tabTitle = contentConstants.searchResultsTabTitle();
		String anchorPrefix = "Content.Search.Results";
		
		//ResizableContainer resizableContainer = new ResizableContainer(titleListPanel, tabTitle, anchorPrefix);
		ResizableContainer resizableContainer = new ResizableContainer(titleListPanel, null, anchorPrefix);
		resizableContainer.addHeightOffsettingWidget(headerPanel);

		mainContainer = new VerticalContainer();
		mainContainer.addStyleName(STYLE_NAME_SEARCH_RESULTS_PANEL);
		
		mainContainer.add(headerPanel);
		mainContainer.add(resizableContainer);
		
		initWidget(mainContainer);
		
		// actionlist box
		actionsListBox = new ListBoxWidget<String>(false);
		
		// listbox for additional params used by the service 
		parameterListBox = new ListBoxWidget<String>(false);
		parameterListBox.setVisible(false);
		multiSelectParameterListBox = new ListBoxWidget<String>(true);
		multiSelectParameterListBox.setVisible(false);
		
		//cancel button
		cancelButton = new ButtonWidget(contentConstants.cancelButtonName());
		cancelButton.addStyleDependentName(StyleNames.DATALOSS_BUTTON_STYLE);
		cancelButton.addClickHandler(new ClickHandler() {
			public void onClick(ClickEvent event) {
				cancelClickedAction();
			}

			
		});
		// go button
		goButton = new ButtonWidget(contentConstants.goButtonName());
		actionButtonHandler = new TitleListButtonClickListener(actionsListBox, parameterListBox, titleListPanel, serviceMap);
		goButton.addClickHandler(actionButtonHandler); 
		goButton.addStyleDependentName(StyleNames.DO_BUTTON_STYLE);

		// populate the action listbox after all dependent widgets are ready
		buildActionsListWidgets(resizableContainer);

		resizableContainer.addButton(tabTitle, cancelButton);
		resizableContainer.addBottomWidget(tabTitle, actionsListBox);
		resizableContainer.addBottomWidget(tabTitle, parameterListBox);
		resizableContainer.addBottomWidget(tabTitle, multiSelectParameterListBox);
		resizableContainer.addButton(tabTitle, goButton);
		resizableContainer.updateSize();
	}

	private void buildActionsListWidgets(final IResizable resizable) {
		//add action items to actions listbox
		ActionListDataProvider<ITitleService> listItemProvider = new ActionListDataProvider<ITitleService>(
				ITitleService.class, serviceLoader, isSeries);
		for (UiServiceItem item : listItemProvider.getItems(serviceMap)) {
			actionsListBox.addItem(item.getName(), item.getClassName());
		}
		actionsListBox.setSelectedIndex(listItemProvider.getSelectedItemIndex(serviceMap, titleListPanel.getInput()));
		String displayName = actionsListBox.getItemText(actionsListBox.getSelectedIndex());
		if(displayName.trim().isEmpty()) {
			setWidgetsForNoAction();
		}
		
		// show parameter list corresponding to the selected service
		actionsListBox.addChangeHandler(new ChangeHandler() {
			public void onChange(ChangeEvent event) {
				// Don't show the parameter list box and go button until the parameters have 
				// been retrieved.
				parameterListBox.setVisible(false);
				multiSelectParameterListBox.setVisible(false);
				goButton.setEnabled(false);
				
				int selectedIndex = actionsListBox.getSelectedIndex();
				String displayName = actionsListBox.getItemText(selectedIndex);
				// if no action is selected, clear out the state
				if(displayName.trim().isEmpty()) {
					setWidgetsForNoAction();
					Scheduler.get().scheduleDeferred(new ScheduledCommand() {

						@Override
						public void execute() {
							resizable.updateSize();
						}
						
					});
					return;
				}
				
				ITitleActionService selectedAction = serviceMap.getService(displayName);
				//For now, only "Target Sites" use multiselect for the parameters. In future, it is better to refactor
				//by adding new method on ITitleActionService to indicate this multiselect requirement.
				if (selectedAction.getName().equals(contentConstants.runTargetSitesServiceName()) == true ){
					useMultiSelectParameters=true;
					actionButtonHandler.setParameterList(multiSelectParameterListBox);
				}
				else {
					useMultiSelectParameters=false;
					actionButtonHandler.setParameterList(parameterListBox);
				}
				selectedAction.getServiceParameters(new NeptuneAsyncCallback<List<String>>() {
					public void onNeptuneFailure(Throwable caught) {
						// In case of an exception at the very least show the Go button for any 
						// other operation.
						parameterListBox.setVisible(false);
						multiSelectParameterListBox.setVisible(false);
						titleListPanel.reportFailure(caught);
					}

					public void onNeptuneSuccess(List<String> result) {
						// Only if there are any parameters for this service, show them and 
						// also enable the GO button
						if (result != null) {
							if (useMultiSelectParameters == false) {
								setParameterList(parameterListBox, result);
								parameterListBox.setVisible(true);
								multiSelectParameterListBox.setVisible(false);
							}
							else {
								setParameterList(multiSelectParameterListBox, result);
								parameterListBox.setVisible(false);								
								multiSelectParameterListBox.setVisible(true);
							}
						}
						goButton.setEnabled(true);
						
						Scheduler.get().scheduleDeferred(new ScheduledCommand() {

							@Override
							public void execute() {
								resizable.updateSize();
							}
							
						});
					}
				});
				
			}

			// TODO List<String> parameters can be changed to List<Object> parameters
			private void setParameterList(ListBoxWidget<String> listBox, List<String> parameters) {
				listBox.clear();
				for (String p : parameters) {
					String name = p;
					String value = p;
					if ((p != null) && (p.contains(RunNormalizationRuleService.SERVICE_PARAM_SEPARATOR))) {
						String[] pArray = p.split(RunNormalizationRuleService.SERVICE_PARAM_SEPARATOR);
						if (pArray.length > 0) {
							name = pArray[0];
						}
						if (pArray.length > 1) {
							value = pArray[1];
						}
					}
					listBox.addItem(name, value);
				}
			}
		});
		
		resizable.updateSize();
	}
	
    private void cancelClickedAction() {
    	titleListPanel.getAnchorChangeNotifier().anchorChanged("");
    	titleListPanel.fireEvent(new ViewCancelEvent());
	}

	private void setWidgetsForNoAction() {
		actionsListBox.setSelectedItem("");
		parameterListBox.clear();
		parameterListBox.setVisible(false);
		goButton.setEnabled(false);
		cancelButton.setEnabled(true);
	}

}
