/**
 * File Name	:	SearchTabPanel.java
 * Created By	:	Sanjay Khattar (sanjay.khattar@ericsson.com)
 * Date Created	:	Sep 12, 2012 5:18:27 PM
 * Purpose		:	
 *
 * (c) Ericsson Television Inc. 
 */
package com.tandbergtv.cms.portal.content.client.tab.search;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.i18n.ContentConstants;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldProviderResults;
import com.tandbergtv.cms.portal.ui.title.client.criteria.IMdmFieldProvider;
import com.tandbergtv.cms.portal.ui.title.client.criteria.IMdmFieldProviderAsync;
import com.tandbergtv.cms.portal.ui.title.client.criteria.TreeCreator;
import com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.AssetFieldTreeObject;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.AssetTreeObject;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.PMMFieldProvider;
import com.tandbergtv.cms.portal.ui.title.client.criteria.contentclass.ContentClassInfo;
import com.tandbergtv.cms.portal.ui.title.client.criteria.contentclass.IContentClassProvider;
import com.tandbergtv.cms.portal.ui.title.client.criteria.contentclass.IContentClassProviderAsync;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UiColumn;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UiSortInfo;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.messagearea.MessageArea;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.resizablecontainer.ResizableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.TabContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

/**
 * @author esakhat (sanjay.khattar@ericsson.com)
 *
 */
public class SearchTabPanel extends Composite {
	private ResizableContainer resizableContainer;
	private NeptuneSecurity neptuneSecurity;
	private UiCriteriaMode criteriaMode;
	
	private MessageArea messageArea;
	private QuickSearchPanel quickSearchPanel;
	private NewBasicSearchPanel basicSearchPanel;
	private AdvancedSearchPanel advancedSearchPanel;
	private AdvancedSearchPanel savedSearchPanel;
	private SavedSearchListPanel savedSearchListPanel;
	private SimpleContainer savedSearchListWrapper;
	private SearchColumnPanel searchColumnPanel;
	private SearchColumnPanel advancedSearchColumnPanel;
	private SearchColumnPanel savedSearchColumnPanel;
	
	private ContentConstants contentConstants = (ContentConstants) GWT.create(ContentConstants.class);
	private final IContentClassProviderAsync contentClassProvider = GWT
			.create(IContentClassProvider.class);

	final ButtonWidget createSavedSearchButton = new ButtonWidget(contentConstants.createButton());

	final ButtonWidget deleteSavedSearchButton = new ButtonWidget(contentConstants.delButton());

	final ButtonWidget cancelSavedSearchButton = new ButtonWidget(contentConstants.cancelButtonName());
	
	private ButtonWidget searchSavedSearchButton;
	
	private ButtonWidget searchAdvancedSearchButton;

	private ButtonWidget saveAdvancedSearchButton;
	
	final ButtonWidget saveSavedSearchButton;

	private ButtonWidget copySavedSearchButton;

	private BusyIndicator busyIndicator = new BusyIndicator();


	public SearchTabPanel(NeptuneSecurity neptuneSecurity, UiCriteriaMode criteriaMode) {
		this.neptuneSecurity = neptuneSecurity;
		this.criteriaMode = criteriaMode;
		
		messageArea = new MessageArea();
		messageArea.reset();
		
		searchColumnPanel = new SearchColumnPanel(criteriaMode, true, true);
		advancedSearchColumnPanel = new SearchColumnPanel(criteriaMode, false, false);
		savedSearchColumnPanel = new SearchColumnPanel(criteriaMode, false, false);
		
		String anchorPrefix = "Content.Search";
		if (UiCriteriaMode.SERIES.equals(criteriaMode)) {
			anchorPrefix = "Content.SeriesSearch";
		}

		savedSearchListPanel = new SavedSearchListPanel(searchColumnPanel, neptuneSecurity, criteriaMode);
		final String savedSearchTabTitle = contentConstants.savedTabTitle();
		savedSearchListPanel.setSearchTabPanel(this);
				
		savedSearchPanel = new AdvancedSearchPanel(savedSearchColumnPanel, neptuneSecurity, criteriaMode);
		savedSearchPanel.setSearchTabPanel(this);

		savedSearchListWrapper = new MessageEmitterSimpleContainer(); 
		savedSearchListWrapper.setWidget(savedSearchListPanel);
		
		resizableContainer = new ResizableContainer(savedSearchListWrapper, savedSearchTabTitle, anchorPrefix, messageArea);
		initWidget(resizableContainer);

		savedSearchColumnPanel.registerMessageListener(resizableContainer);
		savedSearchPanel.registerMessageListener(resizableContainer);

		quickSearchPanel = new QuickSearchPanel(searchColumnPanel, neptuneSecurity, criteriaMode);
		resizableContainer.addTab(quickSearchPanel, contentConstants.quickSearchTabTitle());
		
		basicSearchPanel = new NewBasicSearchPanel(searchColumnPanel, criteriaMode, messageArea);
		resizableContainer.addTab(basicSearchPanel, contentConstants.basicSearchHeader());
		
		advancedSearchPanel = new AdvancedSearchPanel(advancedSearchColumnPanel, neptuneSecurity, criteriaMode);
		resizableContainer.addTab(advancedSearchPanel, contentConstants.advancedSearchHeader());
		advancedSearchPanel.setSearchTabPanel(this);
		advancedSearchColumnPanel.registerMessageListener(resizableContainer);
		
		resizableContainer.addTab(searchColumnPanel, contentConstants.preferencesTabTitle());
		
		resizableContainer.reset();

		TabContainer tabContainer = resizableContainer.getTabContainer();
		tabContainer.addSelectionHandler(new SelectionHandler<Integer>() {
			@Override
			public void onSelection(SelectionEvent<Integer> event) {
				int selectedTabIndex = event.getSelectedItem();
				switch (selectedTabIndex) {
					case 0:
						break;
					case 1:
						quickSearchPanel.resetMessageListener();
						quickSearchPanel.resetFocus();
						break;
					case 2:
						break;
					case 3:
						advancedSearchPanel.resetMessageListener();
					case 4:
						searchColumnPanel.init(new NeptuneAsyncCallback<Void>() {

							@Override
							public void onNeptuneFailure(Throwable caught) {
								messageArea.setErrorMessage(contentConstants.errorLoadingColumns());
							}

							@Override
							public void onNeptuneSuccess(Void result) {
							}
						});
					default:
						break;
				}
			}
		});
				
		resizableContainer.addButton(savedSearchTabTitle, createSavedSearchButton);
		createSavedSearchButton.addStyleDependentName(StyleNames.ACT_TOWARDS_SAVE_BUTTON_STYLE);
		createSavedSearchButton.addClickHandler(new ClickHandler() {

			@Override
			public void onClick(ClickEvent event) {
				goToSavedSearch(-1);
			}
			
		});

		resizableContainer.addButton(savedSearchTabTitle, deleteSavedSearchButton);
		deleteSavedSearchButton.addStyleDependentName(StyleNames.DATALOSS_BUTTON_STYLE);
		deleteSavedSearchButton.addClickHandler(new ClickHandler() {

			@Override
			public void onClick(ClickEvent event) {
				savedSearchListPanel.deleteSelected();
			}
			
		});
		
		saveSavedSearchButton = savedSearchPanel.buildSaveSearchButton();
		savedSearchPanel.setSaveSearchButton(saveSavedSearchButton);
		resizableContainer.addButton(savedSearchTabTitle, saveSavedSearchButton);
		saveSavedSearchButton.setVisible(false);
		
		searchSavedSearchButton = savedSearchPanel.buildSearchButton();
		resizableContainer.addButton(savedSearchTabTitle, searchSavedSearchButton);
		searchSavedSearchButton.setVisible(false);
		
		copySavedSearchButton = savedSearchPanel.buildCopySearchButton();
		savedSearchPanel.setCopySearchButton(copySavedSearchButton);
		resizableContainer.addButton(savedSearchTabTitle, copySavedSearchButton);
		copySavedSearchButton.setVisible(false);
		
		resizableContainer.addButton(savedSearchTabTitle, cancelSavedSearchButton);
		cancelSavedSearchButton.addStyleDependentName(StyleNames.DATALOSS_BUTTON_STYLE);
		cancelSavedSearchButton.setVisible(false);
		cancelSavedSearchButton.addClickHandler(new ClickHandler() {

			@Override
			public void onClick(ClickEvent event) {
				showListView();
			}
			
		});

		searchAdvancedSearchButton = advancedSearchPanel.buildSearchButton();
		resizableContainer.addButton(contentConstants.advancedSearchHeader(), searchAdvancedSearchButton);

		saveAdvancedSearchButton = advancedSearchPanel.buildSaveSearchButton();
		advancedSearchPanel.setSaveSearchButton(saveAdvancedSearchButton);
		resizableContainer.addButton(contentConstants.advancedSearchHeader(), saveAdvancedSearchButton);
		
		initializeAssetTreeObj();
	}

	/**
	 * @return the resizableContainer
	 */
	public ResizableContainer getResizableContainer() {
		return resizableContainer;
	}

	/**
	 * @param w
	 * @see com.tandbergtv.neptune.widgettoolkit.client.widget.composite.resizablecontainer.ResizableContainer#addHeightOffsettingWidget(com.google.gwt.user.client.ui.Widget)
	 */
	public void addHeightOffsettingWidget(Widget w) {
		resizableContainer.addHeightOffsettingWidget(w);
	}

	/**
	 * @param offsetHeight
	 * @see com.tandbergtv.neptune.widgettoolkit.client.widget.composite.resizablecontainer.ResizableContainer#setOffsetHeight(int)
	 */
	public void setOffsetHeight(int offsetHeight) {
		resizableContainer.setOffsetHeight(offsetHeight);
	}
	
	public HandlerRegistration addTitleSearchHandler(TitleSearchHandler handler) {
		if (savedSearchPanel != null) {
			savedSearchPanel.addTitleSearchHandler(handler);
		}
		if (quickSearchPanel != null) {
			quickSearchPanel.addTitleSearchHandler(handler);
		}
		if (basicSearchPanel != null) {
			basicSearchPanel.addTitleSearchHandler(handler);
		}
		if (advancedSearchPanel != null) {
			advancedSearchPanel.addTitleSearchHandler(handler);
		}
		if (savedSearchListPanel != null) {
			savedSearchListPanel.addTitleSearchHandler(handler);
		}
		return addHandler(handler, TitleSearchEvent.TYPE);
	}
	
	private void initializeAssetTreeObj() {
		AssetTreeObject.initialize(new AsyncCallback<Void>() {

			@Override
			public void onFailure(Throwable caught) {
				messageArea.setErrorMessage(contentConstants.errorLoadingSpec());
			}

			@Override
			public void onSuccess(Void result) {
				loadSearchColumns();
			}
			
		});
	}

	private void loadSearchColumns() {
		searchColumnPanel.init(new NeptuneAsyncCallback<Void>() {

			@Override
			public void onNeptuneFailure(Throwable caught) {
				messageArea.setErrorMessage(contentConstants.errorLoadingColumns());
			}

			@Override
			public void onNeptuneSuccess(Void result) {
				loadContentClasses();
			}
		});
	}
	
	private void loadContentClasses() {
		contentClassProvider.getContentClassInfo(new NeptuneAsyncCallback<ContentClassInfo>() {

			@Override
			public void onNeptuneFailure(Throwable caught) {
				messageArea.setErrorMessage(contentConstants.errorLoadingContentClasses());
			}

			@Override
			public void onNeptuneSuccess(ContentClassInfo result) {
				loadSpecification();
				PMMFieldProvider.setContentClasses(result.getContentClasses());
				AssetFieldTreeObject.setFieldOptions(result.getContentClassOptions());
			}
		});
	}

	private void loadSpecification() {
		IMdmFieldProviderAsync specManagerService =  GWT.create(IMdmFieldProvider.class);
		specManagerService.getFields(TreeCreator.getSpecLastUpdateDate(), new NeptuneAsyncCallback<FieldProviderResults>() {
			public void onNeptuneFailure(Throwable caught) {
				messageArea.setErrorMessage(contentConstants.errorLoadingSpec());
				busyIndicator.hide();
			}

			public void onNeptuneSuccess(FieldProviderResults result) {
				// set spec and fire event to change tab contents
				if(result.requiresUpdate())
					TreeCreator.setSpec(result);
				buildUi();
			}
		});
	}
	
	private void buildUi() {
		basicSearchPanel.reset();
	}

	public UiColumn getSortColumn(UiSortInfo partialSortInfo) {
		return searchColumnPanel.getUiColumnForSavedSortColumn(partialSortInfo);
	}

	/**
	 * @return the advancedSearchPanel
	 */
	public AdvancedSearchPanel getAdvancedSearchPanel() {
		return advancedSearchPanel;
	}

	public void selectTab(String tabTitle) {
		resizableContainer.selectTab(tabTitle);
	}

	public void goToSavedSearch(final int titleSearchId) {
		
		savedSearchColumnPanel.init(new NeptuneAsyncCallback<Void>() {

			@Override
			public void onNeptuneFailure(Throwable caught) {
				messageArea.setErrorMessage(contentConstants.errorLoadingColumns());
			}

			@Override
			public void onNeptuneSuccess(Void result) {
				showSearchView(titleSearchId);
			}
		});


	}
	
	public void showListView() {
		this.selectTab(contentConstants.savedTabTitle());
		savedSearchListWrapper.setWidget(savedSearchListPanel);
		savedSearchListPanel.refreshTable();
		createSavedSearchButton.setVisible(true);
		deleteSavedSearchButton.setVisible(true);
		cancelSavedSearchButton.setVisible(false);
		saveSavedSearchButton.setVisible(false);
		searchSavedSearchButton.setVisible(false);
		copySavedSearchButton.setVisible(false);
	}

	public void showSearchView(int titleSearchId) {
		this.selectTab(contentConstants.savedTabTitle());
		savedSearchPanel.loadCriteria(titleSearchId);
		savedSearchListWrapper.setWidget(savedSearchPanel);
		createSavedSearchButton.setVisible(false);
		deleteSavedSearchButton.setVisible(false);
		cancelSavedSearchButton.setVisible(true);
		saveSavedSearchButton.setVisible(true);
		searchSavedSearchButton.setVisible(true);
		if (titleSearchId > 0) {
			copySavedSearchButton.setVisible(true);
		}
		else {
			copySavedSearchButton.setVisible(false);
		}
	}
}
