package com.tandbergtv.cms.portal.content.client.tab.search;

import java.util.List;

import com.google.gwt.event.shared.GwtEvent;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilter;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UiColumn;

/**
 * Event for a title search being initiated.
 * 
 * @author dweiner
 * 
 */
public class TitleSearchEvent extends GwtEvent<TitleSearchHandler> {

	public static final Type<TitleSearchHandler> TYPE = new Type<TitleSearchHandler>();
	private UITitleFilter titleFilter;
	private List<UiColumn> displayColumns;

	/**
	 * Creates a title search event.
	 * 
	 * @param titleFilter
	 *            The title filter for the search.
	 */
	public TitleSearchEvent(UITitleFilter titleFilter, List<UiColumn> displayColumns) {
		setTitleFilter(titleFilter);
		setDisplayColumns(displayColumns);
	}

	@Override
	protected void dispatch(TitleSearchHandler handler) {
		handler.search(this);
	}

	@Override
	public com.google.gwt.event.shared.GwtEvent.Type<TitleSearchHandler> getAssociatedType() {
		return TYPE;
	}

	/**
	 * Sets the title filter for the search.
	 * 
	 * @param titleFilter
	 *            The title filter for the search.
	 */
	public void setTitleFilter(UITitleFilter titleFilter) {
		this.titleFilter = titleFilter;
	}

	/**
	 * Returns the title filter for the search.
	 * 
	 * @return
	 */
	public UITitleFilter getTitleFilter() {
		return titleFilter;
	}

	public List<UiColumn> getDisplayColumns() {
		return displayColumns;
	}

	public void setDisplayColumns(List<UiColumn> displayColumns) {
		this.displayColumns = displayColumns;
	}

}
