/*
 * Created on Aug 12, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.cms.portal.content.client.tab.search;

import com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.tandbergtv.neptune.widgettoolkit.client.application.WidgetFactory;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem.AnchorChangeListener;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.LazyViewWidgetFactory;

/**
 * The Widget Factory for the Content Search menu item
 * 
 * @author Vijay Silva
 */
public class TitleSearchWidgetFactory extends LazyViewWidgetFactory implements WidgetFactory {

	/**
	 * Constructor
	 * 
	 * @param specificationName The name of the specification to use when building the title view
	 */
	public TitleSearchWidgetFactory(UiCriteriaMode criteriaMode) {
		super(new TitleSearchView(criteriaMode));
	}

	@Override
	public TitleSearchView getInstance() {
		return (TitleSearchView) super.getInstance();
	}

	@Override
	public void setAnchorChangeNotifier(AnchorChangeListener anchorChangeNotifier) {
		super.setAnchorChangeNotifier(anchorChangeNotifier);
		getInstance().setAnchorChangeNotifier(anchorChangeNotifier);
	}
}
