/*
 * Created on Apr 30, 2010
 * 
 * (C) Copyright TANDBERG Television Inc.
 */

package com.tandbergtv.cms.portal.content.client.title.model;

import com.google.gwt.user.client.rpc.IsSerializable;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.UITitleMetadata;

/**
 * Title on which actions can be taken that require title metadata
 * 
 * @author Vijay Silva
 */
public class UIActionTitle implements IsSerializable {

	/* Properties */
	private Long titleId;
	private String version;
	private UITitleMetadata metadata;

	/**
	 * Constructor
	 */
	public UIActionTitle() {
	}

	/**
	 * @return the titleId
	 */
	public Long getTitleId() {
		return titleId;
	}

	/**
	 * @param titleId the titleId to set
	 */
	public void setTitleId(Long titleId) {
		this.titleId = titleId;
	}

	/**
	 * @return the version
	 */
	public String getVersion() {
		return version;
	}

	/**
	 * @param version the version to set
	 */
	public void setVersion(String version) {
		this.version = version;
	}

	/**
	 * @return the metadata
	 */
	public UITitleMetadata getMetadata() {
		return metadata;
	}

	/**
	 * @param metadata the metadata to set
	 */
	public void setMetadata(UITitleMetadata metadata) {
		this.metadata = metadata;
	}

	/**
	 * Determine if the metadata model must be used for compare
	 * 
	 * @return true to use metadata model, false otherwise
	 */
	public boolean useMetadataModel() {
		return (this.metadata != null);
	}
}
