/*
 * Created on Apr 27, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.cms.portal.content.client.title.model;

import java.util.List;

import com.google.gwt.user.client.rpc.IsSerializable;
import com.tandbergtv.cms.portal.content.client.title.model.activity.UITitleActivity;
import com.tandbergtv.cms.portal.content.client.title.model.history.UITitleHistory;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.UITitleMetadata;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAsset;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIGroupAsset;
import com.tandbergtv.cms.portal.content.client.title.model.sites.UITitleSites;

/**
 * UI model object that represents a complete title
 * 
 * @author Vijay Silva
 */
public class UITitle implements IsSerializable, ICopyable {

	private Long id;
	private Long contentClassId;
	private Long partnerId;
	
	private UITitleOverview overview;
	private UITitleMetadata metadata;
	private UITitleHistory history;
	private UITitleActivity activity;
	private UITitleSites sites;
	

	/**
	 * Constructor
	 */
	public UITitle() {
	}

	/**
	 * @return the Id
	 */
	public Long getId() {
		return id;
	}

	/**
	 * @param titleId the title ID to set
	 */
	public void setId(Long titleId) {
		this.id = titleId;
	}

	/**
	 * @return the overview
	 */
	public UITitleOverview getOverview() {
		return overview;
	}

	/**
	 * @param overview the overview to set
	 */
	public void setOverview(UITitleOverview overview) {
		this.overview = overview;
	}

	/**
	 * @return the metadata
	 */
	public UITitleMetadata getMetadata() {
		return metadata;
	}

	/**
	 * @param metadata the metadata to set
	 */
	public void setMetadata(UITitleMetadata metadata) {
		this.metadata = metadata;
	}

	/**
	 * @return the history
	 */
	public UITitleHistory getHistory() {
		return history;
	}

	/**
	 * @param history the history to set
	 */
	public void setHistory(UITitleHistory history) {
		this.history = history;
	}

	/**
	 * @return the activity
	 */
	public UITitleActivity getActivity() {
		return activity;
	}

	/**
	 * @param activity the activity to set
	 */
	public void setActivity(UITitleActivity activity) {
		this.activity = activity;
	}

	/**
	 * @return the sites
	 */
	public UITitleSites getSites() {
		return sites;
	}

	/**
	 * @param sites the sites to set
	 */
	public void setSites(UITitleSites sites) {
		this.sites = sites;
	}

	public Long getContentClassId() {
		return contentClassId;
	}

	public void setContentClassId(Long contentClassId) {
		this.contentClassId = contentClassId;
	}

	public Long getPartnerId() {
		return partnerId;
	}

	public void setPartnerId(Long partnerId) {
		this.partnerId = partnerId;
	}


	/**
	 * @see com.tandbergtv.cms.portal.content.client.title.model.ICopyable#createCopy()
	 */
	public UITitle createCopy() {
		UITitle copy = new UITitle();

		copy.setId(this.getId());
		copy.setContentClassId(this.getContentClassId());
		copy.setPartnerId(this.getPartnerId());

		/* Copy the overview */
		if (this.getOverview() != null) {
			copy.setOverview(this.getOverview().createCopy());
		}
		
		/* Copy the metadata */
		if (this.getMetadata() != null) {
			copy.setMetadata(this.getMetadata().createCopy());
		}

		/* Copy the history */
		if (this.getHistory() != null) {
			copy.setHistory(this.getHistory().createCopy());
		}

		/* Copy the activity */
		if (this.activity != null) {
			copy.setActivity(this.getActivity().createCopy());
		}

		/* Copy the sites */
		if (this.getSites() != null) {
			copy.setSites(this.getSites().createCopy());
		}

		return copy;
	}

	public UIAsset findAssetByPath(String path)
	{
		if(path == null || metadata == null) return null;
		String pathElements[] = path.split("/");
		if(pathElements == null || pathElements.length < 1) return null;
		
		UIAsset root = metadata.getRootAsset();
		if(root == null || root.getAssetType() == null) return null;
		
		if(root.getAssetType().equals(pathElements[0])) return root;
		
		// TODO: Implement depth more than 2
		if(root instanceof UIGroupAsset && pathElements.length > 1)
		{
			List<UIAsset> assets = ((UIGroupAsset)root).getChildren().getAll();
			for(UIAsset asset: assets)
			{
				if(asset.getAssetType() != null && asset.getAssetType().equals(pathElements[1])) 
				{
					return asset;
				}
			}
		}
		
		return null;
	}
}
