/*
 * Created on Apr 30, 2010
 * 
 * (C) Copyright TANDBERG Television Inc.
 */

package com.tandbergtv.cms.portal.content.client.title.model;

import com.google.gwt.user.client.rpc.IsSerializable;
import com.tandbergtv.cms.portal.ui.title.client.model.title.UIDistributionStatus;
import com.tandbergtv.cms.portal.ui.title.client.model.title.UITitleStatus;

/**
 * Overview information for a title shown in the header of the Title View
 * 
 * @author Vijay Silva
 */
public class UITitleOverview implements IsSerializable, ICopyable {

	/* Properties */
	private Long id;
	private Long originalId;
	private String version;
	private String originalVersion;
	private String heading;
	private UITitleStatus status;
	private Integer siteID;
	private String currentOriginalVersion;
	private String distributedVersion;
	private UIDistributionStatus distributionStatus;

	private boolean changedAfterDistribution;
	private boolean masterTitleDistributionError;
	
	private String contentClassName;

	/**
	 * Constructor
	 */
	public UITitleOverview() {
	}

	/**
	 * @return the id
	 */
	public Long getId() {
		return id;
	}

	/**
	 * @param id the id to set
	 */
	public void setId(Long id) {
		this.id = id;
	}

	/**
	 * @return the originalId
	 */
	public Long getOriginalId() {
		return originalId;
	}

	/**
	 * @param originalId the originalId to set
	 */
	public void setOriginalId(Long originalId) {
		this.originalId = originalId;
	}

	/**
	 * @return the version
	 */
	public String getVersion() {
		return version;
	}

	/**
	 * @param version the version to set
	 */
	public void setVersion(String version) {
		this.version = version;
	}

	/**
	 * @return the originalVersion
	 */
	public String getOriginalVersion() {
		return originalVersion;
	}

	/**
	 * @param originalVersion the originalVersion to set
	 */
	public void setOriginalVersion(String originalVersion) {
		this.originalVersion = originalVersion;
	}

	/**
	 * @return the heading
	 */
	public String getHeading() {
		return heading;
	}

	/**
	 * @param heading the heading to set
	 */
	public void setHeading(String heading) {
		this.heading = heading;
	}

	/**
	 * @return the status
	 */
	public UITitleStatus getStatus() {
		return status;
	}

	/**
	 * @param status the status to set
	 */
	public void setStatus(UITitleStatus status) {
		this.status = status;
	}

	/**
	 * @return the siteID
	 */
	public Integer getSiteID() {
		return siteID;
	}

	/**
	 * @param siteID the siteID to set
	 */
	public void setSiteID(Integer siteID) {
		this.siteID = siteID;
	}

	/**
	 * @return the currentOriginalVersion
	 */
	public String getCurrentOriginalVersion() {
		return currentOriginalVersion;
	}

	/**
	 * @param currentOriginalVersion the currentOriginalVersion to set
	 */
	public void setCurrentOriginalVersion(String currentOriginalVersion) {
		this.currentOriginalVersion = currentOriginalVersion;
	}

	/**
	 * @return the distributedTitleVersion
	 */
	public String getDistributedVersion() {
		return distributedVersion;
	}

	/**
	 * @param distributedTitleVersion the distributedTitleVersion to set
	 */
	public void setDistributedVersion(String distributedVersion) {
		this.distributedVersion = distributedVersion;
	}

	/**
	 * @return the distributionStatus
	 */
	public UIDistributionStatus getDistributionStatus() {
		return distributionStatus;
	}

	/**
	 * @param distributionStatus the distributionStatus to set
	 */
	public void setDistributionStatus(UIDistributionStatus distributionStatus) {
		this.distributionStatus = distributionStatus;
	}

	/**
	 * @return the changedSinceTargeting
	 */
	public boolean isChangedAfterTargeting() {
		return (isSiteTitle() && !getOriginalVersion().equals(getCurrentOriginalVersion()));
	}

	/**
	 * @return the changedSinceDistribution
	 */
	public boolean isChangedAfterDistribution() {
		return this.changedAfterDistribution;
	}

	/**
	 * @param changedSinceDistribution the changedSinceDistribution to set
	 */
	public void setChangedAfterDistribution(boolean changedSinceDistribution) {
		this.changedAfterDistribution = changedSinceDistribution;
	}

	/**
	 * Determine if this title is a site title
	 * 
	 * @return True if a site title, false otherwise
	 */
	public boolean isSiteTitle() {
		return (getSiteID() != null);
	}

	
	public boolean isMasterTitleDistributionError() 
	{
		return masterTitleDistributionError;
	}

	public void setMasterTitleDistributionError(boolean masterTitleDistributionError) 
	{
		this.masterTitleDistributionError = masterTitleDistributionError;
	}
	
	
	@Override
	public UITitleOverview createCopy() {
		UITitleOverview copy = new UITitleOverview();
		copy.setId(this.getId());
		copy.setOriginalId(this.getOriginalId());
		copy.setVersion(this.getVersion());
		copy.setOriginalVersion(this.getOriginalVersion());
		copy.setHeading(this.getHeading());
		copy.setStatus(this.getStatus());
		copy.setSiteID(this.getSiteID());
		copy.setCurrentOriginalVersion(this.getCurrentOriginalVersion());
		copy.setDistributedVersion(this.getDistributedVersion());
		copy.setDistributionStatus(this.getDistributionStatus());
		copy.setChangedAfterDistribution(this.isChangedAfterDistribution());
		return copy;
	}

	public String getContentClassName() {
		return contentClassName;
	}

	public void setContentClassName(String contentClassName) {
		this.contentClassName = contentClassName;
	}


}
