package com.tandbergtv.cms.portal.content.client.title.model;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

import com.google.gwt.user.client.rpc.IsSerializable;

public class UIVideoPlayer implements IsSerializable, ICopyable{
	Map<String,String> basicVars = new LinkedHashMap<String,String>();
	Map<String,String> flashVars = new LinkedHashMap<String,String>();
	Map<String,String> paramVars = new LinkedHashMap<String,String>();
	
	@Override
	public UIVideoPlayer createCopy() {
		UIVideoPlayer copy = new UIVideoPlayer();
	
		Iterator<String> iter = basicVars.keySet().iterator();
		while ( iter.hasNext() == true) {
			String key = iter.next();
			String val = basicVars.get(key);
			copy.getBasicVars().put(key, val);
		}

		iter = flashVars.keySet().iterator();
		while ( iter.hasNext() == true) {
			String key = iter.next();
			String val = flashVars.get(key);
			copy.getFlashVars().put(key, val);
		}

		iter = paramVars.keySet().iterator();
		while ( iter.hasNext() == true) {
			String key = iter.next();
			String val = paramVars.get(key);
			copy.getParamVars().put(key, val);
		}
		
		return copy;
	}

	public Map<String, String> getBasicVars() {
		return basicVars;
	}

	public void setBasicVars(Map<String, String> basicVars) {
		this.basicVars = basicVars;
	}

	public Map<String, String> getFlashVars() {
		return flashVars;
	}

	public void setFlashVars(Map<String, String> flashVars) {
		this.flashVars = flashVars;
	}

	public Map<String, String> getParamVars() {
		return paramVars;
	}

	public void setParamVars(Map<String, String> paramVars) {
		this.paramVars = paramVars;
	}
	
}
