package com.tandbergtv.cms.portal.content.client.title.model.activity;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.user.client.rpc.IsSerializable;
import com.tandbergtv.cms.portal.content.client.title.model.ICopyable;

public class UITitleActivity implements IsSerializable, ICopyable{
	private Long titleId;
	
	List<UIActivityItem> currentItems = new ArrayList<UIActivityItem>();
	List<UIActivityItem> historyItems = new ArrayList<UIActivityItem>();

	@Override
	public UITitleActivity createCopy() {
		UITitleActivity copy = new UITitleActivity();
		copy.titleId = this.titleId;
				
		for (UIActivityItem currentItem : this.getCurrentItems()) {
			copy.getCurrentItems().add(currentItem.createCopy());
		}	
		
		for (UIActivityItem historyItem : this.getHistoryItems()) {
			copy.getHistoryItems().add(historyItem.createCopy());
		}	
		
		return copy;
	}

	public Long getTitleId() {
		return titleId;
	}

	public void setTitleId(Long titleId) {
		this.titleId = titleId;
	}

	public List<UIActivityItem> getCurrentItems() {
		return currentItems;
	}

	public void setCurrentItems(List<UIActivityItem> currentItems) {
		this.currentItems = currentItems;
	}

	public List<UIActivityItem> getHistoryItems() {
		return historyItems;
	}

	public void setHistoryItems(List<UIActivityItem> historyItems) {
		this.historyItems = historyItems;
	}
}
