/*
 * Created on Apr 21, 2010
 * 
 * (C) Copyright TANDBERG Television Inc.
 */

package com.tandbergtv.cms.portal.content.client.title.model.compare;

import java.util.List;

import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * The Field Difference UI model class
 * 
 * @author Vijay Silva
 */
public class UIFieldDifference implements IsSerializable {

	/* Properties */
	private UIAssetDifference assetDifference;
	private String name;
	private String qualifiedName;
	private String displayName;
	private List<String> qualifiedDisplayName;
	private List<Integer> indices;
	private String field1Value;
	private String field2Value;

	/**
	 * Constructor
	 */
	public UIFieldDifference() {
	}

	/**
	 * @return The asset difference that contains this field difference
	 */
	public UIAssetDifference getAssetDifference() {
		return assetDifference;
	}

	/**
	 * @param assetDifference The parent asset difference to set
	 */
	public void setAssetDifference(UIAssetDifference assetDifference) {
		this.assetDifference = assetDifference;
	}

	/**
	 * @return The field name (TTV XPath)
	 */
	public String getName() {
		return name;
	}

	/**
	 * @param name The field name (TTV XPath) to set
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * @return The qualified name (TTV XPath with indices)
	 */
	public String getQualifiedName() {
		return qualifiedName;
	}

	/**
	 * @param qualifiedName the qualified name (TTV XPath with indices) to set
	 */
	public void setQualifiedName(String qualifiedName) {
		this.qualifiedName = qualifiedName;
	}

	/**
	 * @return the display name
	 */
	public String getDisplayName() {
		return displayName;
	}

	/**
	 * @param displayName the display name to set
	 */
	public void setDisplayName(String displayName) {
		this.displayName = displayName;
	}

	/**
	 * @return the qualifiedDisplayName
	 */
	public List<String> getQualifiedDisplayName() {
		return qualifiedDisplayName;
	}

	/**
	 * @param qualifiedDisplayName the qualifiedDisplayName to set
	 */
	public void setQualifiedDisplayName(List<String> qualifiedDisplayName) {
		this.qualifiedDisplayName = qualifiedDisplayName;
	}

	/**
	 * @return the indices
	 */
	public List<Integer> getIndices() {
		return indices;
	}

	/**
	 * @param indices the indices to set
	 */
	public void setIndices(List<Integer> indices) {
		this.indices = indices;
	}

	/**
	 * @return the value for field1 being compared
	 */
	public String getField1Value() {
		return field1Value;
	}

	/**
	 * @param field1Value the value for field1 to set
	 */
	public void setField1Value(String field1Value) {
		this.field1Value = field1Value;
	}

	/**
	 * @return the value for field2 being compared
	 */
	public String getField2Value() {
		return field2Value;
	}

	/**
	 * @param field2Value the value for field2 to set
	 */
	public void setField2Value(String field2Value) {
		this.field2Value = field2Value;
	}
}
