/*
 * Created on Apr 28, 2010
 * 
 * (C) Copyright TANDBERG Television Inc.
 */

package com.tandbergtv.cms.portal.content.client.title.model.compare;

import java.util.List;

import com.google.gwt.user.client.rpc.IsSerializable;
import com.tandbergtv.cms.portal.content.client.model.UiTable;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetSpecificationListItem;

/**
 * Contains the report along with other data required by the Title Comparison UI
 * 
 * @author Vijay Silva
 */
public class UITitleCompareData implements IsSerializable {

	/* Properties */
	private UITitleCompareReport report;
	private UiTable assetMetadataTable;
	private UiTable fileMetadataTable;
	private List<UIAssetSpecificationListItem> specifications;

	/**
     * 
     */
	public UITitleCompareData() {
	}

	/**
	 * @return the report
	 */
	public UITitleCompareReport getReport() {
		return report;
	}

	/**
	 * @param report the report to set
	 */
	public void setReport(UITitleCompareReport report) {
		this.report = report;
	}

	/**
	 * @return the assetMetadataTable
	 */
	public UiTable getAssetMetadataTable() {
		return assetMetadataTable;
	}

	/**
	 * @param assetMetadataTable the assetMetadataTable to set
	 */
	public void setAssetMetadataTable(UiTable assetMetadataTable) {
		this.assetMetadataTable = assetMetadataTable;
	}

	/**
	 * @return the fileMetadataTable
	 */
	public UiTable getFileMetadataTable() {
		return fileMetadataTable;
	}

	/**
	 * @param fileMetadataTable the fileMetadataTable to set
	 */
	public void setFileMetadataTable(UiTable fileMetadataTable) {
		this.fileMetadataTable = fileMetadataTable;
	}

	/**
	 * @return the specifications
	 */
	public List<UIAssetSpecificationListItem> getSpecifications() {
		return specifications;
	}

	/**
	 * @param specifications the specifications to set
	 */
	public void setSpecifications(List<UIAssetSpecificationListItem> specifications) {
		this.specifications = specifications;
	}
}
