/*
 * Created on Apr 21, 2010
 * 
 * (C) Copyright TANDBERG Television Inc.
 */

package com.tandbergtv.cms.portal.content.client.title.model.compare;

import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * UI Model for the TitleCompareReport model class
 * 
 * @author Vijay Silva
 */
public class UITitleCompareReport implements IsSerializable {

	/* Properties */
	private UIComparedTitle title1;
	private UIComparedTitle title2;
	private UIAssetDifference assetDifference;

	/**
	 * Constructor
	 */
	public UITitleCompareReport() {
	}

	/**
	 * @return The first title compared
	 */
	public UIComparedTitle getTitle1() {
		return title1;
	}

	/**
	 * @param title1 The first title compared
	 */
	public void setTitle1(UIComparedTitle title1) {
		this.title1 = title1;
	}

	/**
	 * @return The second title compared
	 */
	public UIComparedTitle getTitle2() {
		return title2;
	}

	/**
	 * @param title2 The second title compared
	 */
	public void setTitle2(UIComparedTitle title2) {
		this.title2 = title2;
	}

	/**
	 * Get the difference between the root asset in the title, or null if no difference exists
	 * 
	 * @return The difference between the root assets in the title
	 */
	public UIAssetDifference getAssetDifference() {
		return assetDifference;
	}

	/**
	 * @param assetDifference The difference between the root assets in the title
	 */
	public void setAssetDifference(UIAssetDifference assetDifference) {
		this.assetDifference = assetDifference;
	}

	/**
	 * Determine if there are differences between the titles compared
	 * 
	 * @return true if different, false otherwise
	 */
	public boolean isDifferent() {
		return (this.assetDifference != null);
	}
}
