/*
 * Created on Apr 27, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.cms.portal.content.client.title.model.history;

import java.util.Date;

import com.google.gwt.user.client.rpc.IsSerializable;
import com.tandbergtv.cms.portal.content.client.title.model.ICopyable;

/**
 * @author Vijay Silva
 */
public class UIProgressItem implements IsSerializable, ICopyable {

	/* Properties */
	private Long id;
	private Long titleId;
	private Long assetListId;
	private String name;
	private String value;
	private boolean success;
	// Let's keep for now, because it is used to sort items by date
	private Date timestamp;
	// Used to store server formatted date. It should handle locales.
	private String formattedTimestamp;
	private String titleRevision;
	private String sourceComponentName;
	private String sourceEntityName;
	private String sourceId;
	private boolean latestRevision = false;

	/**
	 * Default constructor
	 */
	public UIProgressItem() {
	}

	/**
	 * @return the id
	 */
	public Long getId() {
		return id;
	}

	/**
	 * @param id the id to set
	 */
	public void setId(Long id) {
		this.id = id;
	}

	/**
	 * @return the titleId
	 */
	public Long getTitleId() {
		return titleId;
	}

	/**
	 * @param titleId the titleId to set
	 */
	public void setTitleId(Long titleId) {
		this.titleId = titleId;
	}

	/**
	 * @return the assetListId
	 */
	public Long getAssetListId() {
		return assetListId;
	}

	/**
	 * @param assetListId the assetListId to set
	 */
	public void setAssetListId(Long assetListId) {
		this.assetListId = assetListId;
	}

	/**
	 * @return the name
	 */
	public String getName() {
		return name;
	}

	/**
	 * @param name the name to set
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * @return the value
	 */
	public String getValue() {
		return value;
	}

	/**
	 * @param value the value to set
	 */
	public void setValue(String value) {
		this.value = value;
	}

	/**
	 * @return the success
	 */
	public boolean isSuccess() {
		return success;
	}

	/**
	 * @param success the success to set
	 */
	public void setSuccess(boolean success) {
		this.success = success;
	}

	/**
	 * @return the timestamp
	 */
	public Date getTimestamp() {
		return timestamp;
	}

	/**
	 * @param timestamp the timestamp to set
	 */
	public void setTimestamp(Date timestamp) {
		this.timestamp = timestamp;
	}

	/**
	 * @return the title revision
	 */
	public String getTitleRevision() {
		return titleRevision;
	}

	/**
	 * @param titleRevision the title revision to set
	 */
	public void setTitleRevision(String titleRevision) {
		this.titleRevision = titleRevision;
	}

	/**
	 * @return the sourceComponentName
	 */
	public String getSourceComponentName() {
		return sourceComponentName;
	}

	/**
	 * @param sourceComponentName the sourceComponentName to set
	 */
	public void setSourceComponentName(String sourceComponentName) {
		this.sourceComponentName = sourceComponentName;
	}

	/**
	 * @return the sourceEntityName
	 */
	public String getSourceEntityName() {
		return sourceEntityName;
	}

	/**
	 * @param sourceEntityName the sourceEntityName to set
	 */
	public void setSourceEntityName(String sourceEntityName) {
		this.sourceEntityName = sourceEntityName;
	}

	/**
	 * @return the sourceId
	 */
	public String getSourceId() {
		return sourceId;
	}

	/**
	 * @param sourceId the sourceId to set
	 */
	public void setSourceId(String sourceId) {
		this.sourceId = sourceId;
	}

	/**
	 * @return the latestRevision
	 */
	public boolean isLatestRevision() {
		return latestRevision;
	}

	/**
	 * @param latestRevision the latestRevision to set
	 */
	public void setLatestRevision(boolean latestRevision) {
		this.latestRevision = latestRevision;
	}

	/**
	 * @see com.tandbergtv.cms.portal.content.client.title.model.ICopyable#createCopy()
	 */
	public UIProgressItem createCopy() {
		UIProgressItem copy = new UIProgressItem();

		copy.id = this.id;
		copy.titleId = this.titleId;
		copy.assetListId = this.assetListId;
		copy.name = this.name;
		copy.value = this.value;
		copy.success = this.success;
		copy.timestamp = (this.timestamp == null) ? null : new Date(this.timestamp.getTime());
		copy.titleRevision = this.titleRevision;
		copy.sourceComponentName = this.sourceComponentName;
		copy.sourceEntityName = this.sourceEntityName;
		copy.sourceId = this.sourceId;
		copy.latestRevision = this.latestRevision;

		return copy;
	}

	public String getFormattedTimestamp() {
		return formattedTimestamp;
	}

	public void setFormattedTimestamp(String formattedTimestamp) {
		this.formattedTimestamp = formattedTimestamp;
	}

}
