/*
 * Created on Apr 27, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.cms.portal.content.client.title.model.history;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.user.client.rpc.IsSerializable;
import com.tandbergtv.cms.portal.content.client.title.model.ICopyable;

/**
 * The UI Model representing the history items for a title
 * 
 * @author Vijay Silva
 */
public class UITitleHistory implements IsSerializable, ICopyable {

	/* Properties */
	List<UIProgressItem> progressItems = new ArrayList<UIProgressItem>();
	private String latestTitleVersion;
	private String normalizedName;
	private String updatedName;
	private boolean isSeriesTitle = false;

	public boolean isSeriesTitle() {
		return isSeriesTitle;
	}

	public void setSeriesTitle(boolean isSeriesTitle) {
		this.isSeriesTitle = isSeriesTitle;
	}

	/**
	 * Constructor
	 */
	public UITitleHistory() {
	}

	public String getNormalizedName() {
		return normalizedName;
	}

	public void setNormalizedName(String normalizedName) {
		this.normalizedName = normalizedName;
	}

	public String getUpdatedName() {
		return updatedName;
	}

	public void setUpdatedName(String updatedName) {
		this.updatedName = updatedName;
	}

	/**
	 * @return the progress items
	 */
	public List<UIProgressItem> getProgressItems() {
		return progressItems;
	}

	/**
	 * @param progressItems the progress items to set
	 */
	public void setProgressItems(List<UIProgressItem> progressItems) {
		this.progressItems = (progressItems != null) ? progressItems
		        : new ArrayList<UIProgressItem>();
	}

	/**
	 * @return the latestTitleVersion
	 */
	public String getLatestTitleVersion() {
		return latestTitleVersion;
	}

	/**
	 * @param latestTitleVersion the latestTitleVersion to set
	 */
	public void setLatestTitleVersion(String latestTitleVersion) {
		this.latestTitleVersion = latestTitleVersion;
	}

	/**
	 * @see com.tandbergtv.cms.portal.content.client.title.model.ICopyable#createCopy()
	 */
	public UITitleHistory createCopy() {
		UITitleHistory copy = new UITitleHistory();

		copy.setLatestTitleVersion(this.getLatestTitleVersion());

		/* Create a copy of all the progress items */
		for (UIProgressItem progressItem : this.getProgressItems()) {
			copy.getProgressItems().add(progressItem.createCopy());
		}

		return copy;
	}
}
