/*
 * Created on Jun 24, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.cms.portal.content.client.title.model.metadata;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.user.client.rpc.IsSerializable;
import com.tandbergtv.cms.portal.content.client.title.model.ICopyable;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAsset;
import com.tandbergtv.cms.portal.ui.title.client.model.title.UITitleStatus;

/**
 * UI Model for the Title Metadata Tab View
 * 
 * @author Vijay Silva
 */
public class UITitleMetadata implements IsSerializable, ICopyable {

	/* Properties */
	private UIAsset rootAsset;
	private UITitleStatus titleStatus;
	private List<UITitleValidationMessage> validationMessages = new ArrayList<UITitleValidationMessage>();
	private boolean active = true;

	/**
	 * Constructor
	 */
	public UITitleMetadata() {
	}

	/**
	 * @return the rootAsset
	 */
	public UIAsset getRootAsset() {
		return rootAsset;
	}

	/**
	 * @param rootAsset the rootAsset to set
	 */
	public void setRootAsset(UIAsset rootAsset) {
		this.rootAsset = rootAsset;
	}

	/**
	 * @return the titleStatus
	 */
	public UITitleStatus getTitleStatus() {
		return titleStatus;
	}

	/**
	 * @param titleStatus the titleStatus to set
	 */
	public void setTitleStatus(UITitleStatus titleStatus) {
		this.titleStatus = titleStatus;
	}

	/**
	 * @return the validationMessages
	 */
	public List<UITitleValidationMessage> getValidationMessages() {
		return validationMessages;
	}

	/**
	 * @return true if the title is active
	 */
	public boolean isActive() {
		return active;
	}

	/**
	 * @param active the active flag to set
	 */
	public void setActive(boolean active) {
		this.active = active;
	}

	@Override
	public UITitleMetadata createCopy() {
		UITitleMetadata copy = new UITitleMetadata();

		copy.setTitleStatus(this.getTitleStatus());
		copy.setActive(this.isActive());

		/* Copy the asset tree */
		if (this.getRootAsset() != null) {
			copy.setRootAsset(this.getRootAsset().createCopy());
		}

		/* Copy the validation messages */
		for (UITitleValidationMessage validationMessage : this.getValidationMessages()) {
			copy.getValidationMessages().add(validationMessage.createCopy());
		}

		return copy;
	}
}
