/*
 * Created on Jul 16, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.cms.portal.content.client.title.model.metadata;

import com.google.gwt.user.client.rpc.IsSerializable;
import com.tandbergtv.cms.portal.content.client.title.model.ICopyable;

/**
 * UI Model for the Title Validation Message returned when the back end validates the title
 * 
 * @author Vijay Silva
 */
public class UITitleValidationMessage implements IsSerializable, ICopyable {

	/* Properties */
	private String message;
	private UITitleValidationMessageType messageType;
	private String errorCode;

	/**
	 * Constructor
	 */
	public UITitleValidationMessage() {
	}

	public UITitleValidationMessage(String message, UITitleValidationMessageType messageType, 
			String errorCode) {
		super();
		this.message = message;
		this.messageType = messageType;
		this.errorCode = errorCode;
	}

	/**
	 * Constructor
	 * 
	 * @param message the validation message
	 * @param type The type of the message
	 */
	public UITitleValidationMessage(String message, UITitleValidationMessageType type) {
		this.message = message;
		this.messageType = type;
	}

	/**
	 * @return the message
	 */
	public String getMessage() {
		return message;
	}

	/**
	 * @param message the message to set
	 */
	public void setMessage(String message) {
		this.message = message;
	}

	/**
	 * @return the messageType
	 */
	public UITitleValidationMessageType getMessageType() {
		return messageType;
	}

	/**
	 * @param messageType the messageType to set
	 */
	public void setMessageType(UITitleValidationMessageType messageType) {
		this.messageType = messageType;
	}

	@Override
	public UITitleValidationMessage createCopy() {
		UITitleValidationMessage copy = new UITitleValidationMessage();
		copy.setMessage(this.getMessage());
		copy.setMessageType(this.getMessageType());
		return copy;
	}

	/**
	 * @return the errorCode
	 */
	public String getErrorCode() {
		return errorCode;
	}

	/**
	 * @param errorCode the errorCode to set
	 */
	public void setErrorCode(String errorCode) {
		this.errorCode = errorCode;
	}
}
