/*
 * Created on Feb 24, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.cms.portal.content.client.title.model.metadata.asset;

import java.util.List;
import java.util.Map;

import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * A typed map that provides additional support for managing the fields maintained by the map.
 * 
 * @author Vijay Silva
 */
public interface IUIAssetMap extends Map<String, List<? extends UIAsset>>, IsSerializable {

	/**
	 * Get all child assets maintained in this map
	 * 
	 * @return The list of all child assets
	 */
	public List<UIAsset> getAll();

	/**
	 * Get all group assets with matching asset type
	 * 
	 * @param groupAssetType The asset type
	 * @return The matching group assets, or null if no matching assets exist
	 * @throws RuntimeException thrown if the matching assets found are not group assets
	 */
	public List<UIGroupAsset> getGroups(String groupAssetType);

	/**
	 * Get all item assets with matching asset type
	 * 
	 * @param itemAssetType The asset type
	 * @return The first matching item assets, or null if no matching assets exists
	 * @throws RuntimeException thrown if the matching assets found are not item assets
	 */
	public List<UIItemAsset> getItems(String itemAssetType);

	/**
	 * Add an asset to the asset map
	 * 
	 * @param asset The asset
	 * @throws RuntimeException thrown if the asset map contains assets with the same asset type but
	 *         different asset subclass from the asset being added.
	 */
	public void addAsset(UIAsset asset);

	/**
	 * Removes the asset from the asset map
	 * 
	 * @param asset the asset to remove
	 * @return true if the asset was removed, false otherwise
	 */
	public boolean removeAsset(UIAsset asset);
}
