/*
 * Created on Feb 23, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.cms.portal.content.client.title.model.metadata.asset;

import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * Visitor pattern support for the subclasses of the UIAsset model object.
 * 
 * @author Vijay Silva
 */
public interface IUIAssetVisitor extends IsSerializable {

	/**
	 * Visit a 'Group' asset
	 * 
	 * @param group The UIGroupAsset to visit
	 */
	public void visit(UIGroupAsset group);

	/**
	 * Visit an 'Item' asset
	 * 
	 * @param item The UIItemAsset to visit
	 */
	public void visit(UIItemAsset item);
}
