/*
 * Created on Feb 24, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.cms.portal.content.client.title.model.metadata.asset;

import java.util.List;

/**
 * A collection that provides additional support for managing fields.
 * 
 * @author Vijay Silva
 */
public interface IUIFieldMap {

	/**
	 * Get all the fields maintained in this map. The list is built for each request, and changing
	 * this list does not change the state of this field map.
	 * 
	 * @return a list of all the fields
	 */
	public List<UIField> getAll();

	/**
	 * Remove all the fields maintained by this field map
	 */
	public void removeAll();

	/**
	 * Get a count of all the fields in this field map
	 * 
	 * @return The count of all fields
	 */
	public int getFieldCount();

	/**
	 * Get all fields with matching name
	 * 
	 * @param name The field name
	 * @return the list of fields with matching name
	 */
	public List<UIField> getFields(String name);

	/**
	 * Get all fields with matching name and field type
	 * 
	 * @param <FieldType> The field type
	 * @param name The field name
	 * @param fieldType The field type class
	 * @return The list of fields with matching name or null if the list doesn't match the type
	 *         specified.
	 */
	public <FieldType extends UIField> List<FieldType> getFields(String name,
	        Class<FieldType> fieldType);

	/**
	 * Get a single field with matching name
	 * 
	 * @param name The field name
	 * @return The first matching field, or null if no such field exists
	 */
	public UIField getField(String name);

	/**
	 * Gets the count of all fields with the given name
	 * 
	 * @param fieldName The field name
	 * @return The count of fields with matching name
	 */
	public int getFieldCount(String fieldName);

	/**
	 * Add the field to the list of fields.
	 * 
	 * @param field The field to add
	 */
	public void addField(UIField field);

	/**
	 * Add a field at the specified index for fields with the same name
	 * 
	 * @param field The field
	 * @param index the index
	 * @throws RuntimeException thrown if the field added doesn't match the existing field type
	 */
	public void addField(UIField field, int index);

	/**
	 * Removes an existing field
	 * 
	 * @param field the field to remove
	 * @return The field that was removed, or null if no field was removed
	 */
	public boolean removeField(UIField field);

	/**
	 * Remove all existing fields with matching name
	 * 
	 * @param fieldName the field name
	 */
	public void removeFields(String fieldName);
}
