/*
 * Created on Feb 23, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.cms.portal.content.client.title.model.metadata.asset;

import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * Visitor pattern support for the subclasses of the UIField model object.
 * 
 * @author Vijay Silva
 */
public interface IUIFieldVisitor extends IsSerializable {

	/**
	 * Visit a 'Complex' field
	 * 
	 * @param complexField The field to visit
	 */
	public void visit(UIComplexField complexField);

	/**
	 * Visit an 'Simple' boolean field
	 * 
	 * @param simpleField The field to visit
	 */
	public void visit(UIBooleanField simpleField);

	/**
	 * Visit an 'Simple' integer field
	 * 
	 * @param simpleField The field to visit
	 */
	public void visit(UIIntegerField simpleField);

	/**
	 * Visit an 'Simple' float field
	 * 
	 * @param simpleField The field to visit
	 */
	public void visit(UIFloatField simpleField);

	/**
	 * Visit an 'Simple' date field
	 * 
	 * @param simpleField The field to visit
	 */
	public void visit(UIDateField simpleField);

	/**
	 * Visit an 'Simple' time field
	 * 
	 * @param simpleField The field to visit
	 */
	public void visit(UITimeField simpleField);

	/**
	 * Visit an 'Simple' string field
	 * 
	 * @param simpleField The field to visit
	 */
	public void visit(UIStringField simpleField);
}
