/*
 * Created on Mar 11, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.cms.portal.content.client.title.model.metadata.asset;

import java.util.HashMap;
import java.util.Map;

import com.google.gwt.user.client.rpc.IsSerializable;
import com.tandbergtv.cms.portal.content.client.title.model.ICopyable;

/**
 * Represents an Asset File
 * 
 * @author Vijay Silva
 */
public class UIAssetFile implements IsSerializable, ICopyable {

	/* Properties */
	private Long id;
	private UIAsset parentAsset;
	private UIAssetFile parentUIAssetFile;
	private boolean active = true;
	private Map<String, UIAssetFileField> fields = new HashMap<String, UIAssetFileField>();

	/**
	 * Constructor
	 */
	public UIAssetFile() {
	}

	/**
	 * @return the id
	 */
	public Long getId() {
		return id;
	}

	/**
	 * @param id the id to set
	 */
	public void setId(Long id) {
		this.id = id;
	}

	/**
	 * @return the parent asset
	 */
	public UIAsset getParentAsset() {
		return parentAsset;
	}

	/**
	 * @param parentAsset the parent asset to set
	 */
	public void setParentAsset(UIAsset parentAsset) {
		this.parentAsset = parentAsset;
	}
	
	/**
	 * @return the parentUIAssetFile
	 */
	public UIAssetFile getParentFile() {
		return parentUIAssetFile;
	}

	/**
	 * @param parentUIAssetFile the parentUIAssetFile to set
	 */
	public void setParentFile(UIAssetFile parentUIAssetFile) {
		this.parentUIAssetFile = parentUIAssetFile;
	}

	/**
	 * @return the active
	 */
	public boolean isActive() {
		return active;
	}

	/**
	 * @param active the active to set
	 */
	public void setActive(boolean active) {
		this.active = active;
	}

	/**
	 * @return the fields
	 */
	public Map<String, UIAssetFileField> getFields() {
		return fields;
	}

	/**
	 * @param fields the fields to set
	 */
	public void setFields(Map<String, UIAssetFileField> fields) {
		if (fields != null) {
			for (UIAssetFileField field : fields.values()) {
				field.setAssetFile(this);
			}
		}

		this.fields = (fields != null) ? fields : new HashMap<String, UIAssetFileField>();
	}

	/**
	 * Add a field for this Asset File
	 * 
	 * @param field the field to add
	 */
	public void addField(UIAssetFileField field) {
		field.setAssetFile(this);
		fields.put(field.getName(), field);
	}

	/**
	 * Remove a field from the Asset File
	 * 
	 * @param field The field to remove
	 * @return true if the field was removed, false otherwise
	 */
	public boolean removeField(UIAssetFileField field) {
		UIAssetFileField removedField = fields.remove(field.getName());

		if (removedField != null) {
			removedField.setAssetFile(null);
			return true;
		}

		return false;
	}

	/**
	 * Create a copy of this asset file
	 * 
	 * @see com.tandbergtv.cms.portal.content.client.title.model.ICopyable#createCopy()
	 */
	public UIAssetFile createCopy() {
		UIAssetFile copy = new UIAssetFile();

		/* Copy all properties */
		copy.setId(this.getId());
		copy.setActive(this.isActive());

		/* Copy all fields */
		for (UIAssetFileField field : this.getFields().values()) {
			UIAssetFileField fieldCopy = field.createCopy();
			copy.addField(fieldCopy);
		}

		return copy;
	}
}
