/*
 * Created on Mar 12, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.cms.portal.content.client.title.model.metadata.asset;

import com.google.gwt.user.client.rpc.IsSerializable;
import com.tandbergtv.cms.portal.content.client.title.model.ICopyable;

/**
 * The root field for an asset file
 * 
 * @author Vijay Silva
 */
public class UIAssetFileField implements IsSerializable, ICopyable {

	/* Properties */
	private UIAssetFile assetFile;
	private UISimpleField<?> field;

	/**
	 * Constructor
	 */
	public UIAssetFileField() {
	}

	/**
	 * @return the assetFile
	 */
	public UIAssetFile getAssetFile() {
		return assetFile;
	}

	/**
	 * @param assetFile the assetFile to set
	 */
	public void setAssetFile(UIAssetFile assetFile) {
		this.assetFile = assetFile;
	}

	/**
	 * @return the name
	 */
	public String getName() {
		return (field != null) ? field.getName() : null;
	}

	/**
	 * Get the field containing the value
	 * 
	 * @return The field
	 */
	public UISimpleField<?> getField() {
		return field;
	}

	/**
	 * @param field the field to set
	 */
	public void setField(UISimpleField<?> field) {
		this.field = field;
	}

	/**
	 * Create a copy of this file field
	 * 
	 * @see com.tandbergtv.cms.portal.content.client.title.model.ICopyable#createCopy()
	 */
	public UIAssetFileField createCopy() {
		UIAssetFileField copy = new UIAssetFileField();

		/* Copy all properties */
		if (this.getField() != null) {
			copy.setField(this.getField().createCopy());
		}

		return copy;
	}
}
