/*
 * Created on Jul 9, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.cms.portal.content.client.title.model.metadata.asset;

import com.google.gwt.user.client.rpc.IsSerializable;
import com.tandbergtv.cms.portal.content.client.title.model.ICopyable;

/**
 * A file path that is allowed as a File URI value in the File asset metadata
 * 
 * @author Vijay Silva
 */
public class UIAssetFilePath implements IsSerializable, ICopyable {

	/* Properties */
	private String repositoryPath;
	private String relativePath;

	/**
	 * Constructor
	 */
	public UIAssetFilePath() {
	}

	/**
	 * @return the repositoryPath
	 */
	public String getRepositoryPath() {
		return repositoryPath;
	}

	/**
	 * @param repositoryPath the repositoryPath to set
	 */
	public void setRepositoryPath(String repositoryPath) {
		this.repositoryPath = repositoryPath;
	}

	/**
	 * @return the relativePath
	 */
	public String getRelativePath() {
		return relativePath;
	}

	/**
	 * @param relativePath the relativePath to set
	 */
	public void setRelativePath(String relativePath) {
		this.relativePath = relativePath;
	}

	/**
	 * Get the complete path for the file
	 * 
	 * @return The complete path
	 */
	public String getFilePath() {
		String path = "";

		if (repositoryPath != null) {
			path += repositoryPath;
		}

		if (relativePath != null) {
			path += relativePath;
		}

		return path;
	}

	@Override
	public UIAssetFilePath createCopy() {
		UIAssetFilePath copy = new UIAssetFilePath();
		copy.setRepositoryPath(this.getRepositoryPath());
		copy.setRelativePath(this.getRelativePath());
		return copy;
	}
}
