/*
 * Created on Feb 24, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.cms.portal.content.client.title.model.metadata.asset;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 * Maintains the collections of fields using the field name as the key.
 * 
 * @author Vijay Silva
 */
public class UIAssetMap extends HashMap<String, List<? extends UIAsset>> implements IUIAssetMap {

	/* Serialization UID */
	private static final long serialVersionUID = 4960347958825347186L;

	/**
	 * Constructor
	 */
	public UIAssetMap() {
		super();
	}

	/**
	 * {@inheritDoc}
	 */
	public List<UIAsset> getAll() {
		List<UIAsset> allAssets = new ArrayList<UIAsset>();

		for (List<? extends UIAsset> assets : this.values()) {
			if (assets != null)
				allAssets.addAll(assets);
		}

		return allAssets;
	}

	/**
	 * {@inheritDoc}
	 */
	@SuppressWarnings("unchecked")
	public List<UIGroupAsset> getGroups(String groupAssetType) {
		/* Get the matching assets and verify the runtime type of the list is correct */
		List<UIGroupAsset> matchedAssets = (List<UIGroupAsset>) this.get(groupAssetType);
		this.getFirstElement(matchedAssets);
		return (matchedAssets != null) ? matchedAssets : new ArrayList<UIGroupAsset>();
	}

	/**
	 * {@inheritDoc}
	 */
	@SuppressWarnings("unchecked")
	public List<UIItemAsset> getItems(String itemAssetType) {
		/* Get the matching assets and verify the runtime type of the list is correct */
		List<UIItemAsset> matchedAssets = (List<UIItemAsset>) this.get(itemAssetType);
		this.getFirstElement(matchedAssets);
		return (matchedAssets != null) ? matchedAssets : new ArrayList<UIItemAsset>();
	}

	/**
	 * {@inheritDoc}
	 */
	@SuppressWarnings("unchecked")
	public void addAsset(UIAsset asset) {
		if (asset == null)
			return;

		asset.accept(new IUIAssetVisitor() {
			/* Add the new group asset */
			public void visit(UIGroupAsset group) {
				/* Get the existing fields with the same name */
				String assetType = group.getAssetType();
				List<UIGroupAsset> assets = (List<UIGroupAsset>) get(assetType);
				if (assets == null) {
					assets = new ArrayList<UIGroupAsset>();
					put(assetType, assets);
				}

				/* Verify that added field is same type as existing fields and add new field */
				getFirstElement(assets);
				assets.add(group);
			}

			/* Add the new item asset */
			public void visit(UIItemAsset item) {
				/* Get the existing fields with the same name */
				String assetType = item.getAssetType();
				List<UIItemAsset> assets = (List<UIItemAsset>) get(assetType);
				if (assets == null) {
					assets = new ArrayList<UIItemAsset>();
					put(assetType, assets);
				}

				/* Verify that added field is same type as existing fields and add new field */
				getFirstElement(assets);
				assets.add(item);
			}
		});
	}

	/**
	 * {@inheritDoc}
	 */
	public boolean removeAsset(UIAsset asset) {
		if (asset == null)
			return false;

		boolean result = false;
		String assetType = asset.getAssetType();
		List<? extends UIAsset> matchedAssets = this.get(assetType);
		if (matchedAssets != null) {
			result = matchedAssets.remove(asset);

			/* Remove the entry from the map if empty */
			if (matchedAssets.size() == 0)
				this.remove(assetType);
		}

		return result;
	}

	/*
	 * Method to verify that the list contains elements of the appropriate type at runtime
	 */
	private <T extends UIAsset> T getFirstElement(List<T> fields) {
		try {
			return (fields != null && fields.size() > 0) ? fields.get(0) : null;
		} catch (ClassCastException cce) {
			throw new RuntimeException("The field is not of the expected type.", cce);
		}
	}
}
