/*
 * Created on Jun 4, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.cms.portal.content.client.title.model.metadata.asset;

import com.tandbergtv.cms.portal.ui.title.client.model.datatype.BooleanDataType;
import com.tandbergtv.cms.portal.ui.title.client.model.datatype.UIFieldDataType;

/**
 * A Simple Field that contains a boolean value
 * 
 * @author Vijay Silva
 */
public class UIBooleanField extends UISimpleField<Boolean> {

	/* Properties */
	private UIFieldDataType dataType = new BooleanDataType();

	/**
	 * Constructor
	 */
	public UIBooleanField() {
		super();
	}

	/**
	 * Gets the field data type
	 * 
	 * @return the boolean data type
	 */
	@Override
	public UIFieldDataType getDatatype() {
		return this.dataType;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public UIBooleanField createCopy() {
		UIBooleanField copy = new UIBooleanField();
		this.copyBooleanProperties(copy);
		return copy;
	}

	/* Copy the properties */
	protected void copyBooleanProperties(UIBooleanField copy) {
		super.copySimpleFieldProperties(copy);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void accept(IUIFieldVisitor visitor) {
		visitor.visit(this);
	}
}
