/*
 * Created on Jun 4, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.cms.portal.content.client.title.model.metadata.asset;

import com.tandbergtv.cms.portal.ui.title.client.model.datatype.DateDataType;
import com.tandbergtv.cms.portal.ui.title.client.model.datatype.UIFieldDataType;

/**
 * A Simple Field that contains a date value
 * 
 * @author Vijay Silva
 */
public class UIDateField extends UISimpleField<String> {

	/* Properties */
	private UIFieldDataType dataType = new DateDataType();

	/**
	 * Constructor
	 */
	public UIDateField() {
		super();
	}

	/**
	 * Gets the field data type
	 * 
	 * @return the date data type
	 */
	@Override
	public UIFieldDataType getDatatype() {
		return this.dataType;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public UIDateField createCopy() {
		UIDateField copy = new UIDateField();
		this.copyDateProperties(copy);
		return copy;
	}

	/* Copy the properties */
	protected void copyDateProperties(UIDateField copy) {
		super.copySimpleFieldProperties(copy);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void accept(IUIFieldVisitor visitor) {
		visitor.visit(this);
	}
}
