/*
 * Created on Feb 17, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.cms.portal.content.client.title.model.metadata.asset;

import com.google.gwt.user.client.rpc.IsSerializable;
import com.tandbergtv.cms.portal.content.client.title.model.ICopyable;

/**
 * UI Model object representing of an asset field.
 * 
 * @author Vijay Silva
 */
public abstract class UIField implements IsSerializable, ICopyable {

	/* Properties */
	private UIAsset parentAsset;
	private UIField parentField;
	private String name;
	private String xpath;

	/**
	 * Default constructor
	 */
	public UIField() {
	}

	/**
	 * Constructor - Creates a field with the specified parent asset
	 */
	public UIField(UIAsset parent) {
		this.parentAsset = parent;
	}

	/**
	 * @return the parent asset
	 */
	public UIAsset getParentAsset() {
		return parentAsset;
	}

	/**
	 * @param parentAsset the parent asset to set
	 */
	public void setParentAsset(UIAsset parentAsset) {
		this.parentAsset = parentAsset;
	}

	/**
	 * @return the parentField
	 */
	public UIField getParentField() {
		return parentField;
	}

	/**
	 * @param parentField the parentField to set
	 */
	public void setParentField(UIField parentField) {
		this.parentField = parentField;
	}

	/**
	 * @return the TTV field name
	 */
	public String getName() {
		return name;
	}

	/**
	 * @param name the TTV field name to set
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * Create a copy of this field
	 * 
	 * @see com.tandbergtv.cms.portal.content.client.title.model.ICopyable#createCopy()
	 */
	public abstract UIField createCopy();

	/**
	 * Copy all properties of this field to the copy instance provided
	 * 
	 * @param copy The instance to copy all current properties to
	 */
	protected void copyProperties(UIField copy) {
		copy.setName(this.getName());
	}

	/**
	 * The accept method used for the visitor pattern
	 * 
	 * @param visitor The Visitor
	 */
	public abstract void accept(IUIFieldVisitor visitor);

	public String getXpath() {
		return xpath;
	}

	public void setXpath(String xpath) {
		this.xpath = xpath;
	}
		
}
