/*
 * Created on Jun 4, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.cms.portal.content.client.title.model.metadata.asset;

import com.tandbergtv.cms.portal.ui.title.client.model.datatype.FloatDataType;
import com.tandbergtv.cms.portal.ui.title.client.model.datatype.UIFieldDataType;

/**
 * A Simple Field that contains a float value
 * 
 * @author Vijay Silva
 */
public class UIFloatField extends UISimpleField<String> {

	/* Properties */
	private UIFieldDataType dataType = new FloatDataType();

	/**
	 * Constructor
	 */
	public UIFloatField() {
		super();
	}

	/**
	 * Gets the field data type
	 * 
	 * @return the float data type
	 */
	@Override
	public UIFieldDataType getDatatype() {
		return this.dataType;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public UIFloatField createCopy() {
		UIFloatField copy = new UIFloatField();
		this.copyFloatProperties(copy);
		return copy;
	}

	/* Copy the properties */
	protected void copyFloatProperties(UIFloatField copy) {
		super.copySimpleFieldProperties(copy);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void accept(IUIFieldVisitor visitor) {
		visitor.visit(this);
	}
}
