/*
 * Created on Jun 4, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.cms.portal.content.client.title.model.metadata.asset;

import com.tandbergtv.cms.portal.ui.title.client.model.datatype.IntegerDataType;
import com.tandbergtv.cms.portal.ui.title.client.model.datatype.UIFieldDataType;

/**
 * A Simple Field that contains a integer value
 * 
 * @author Vijay Silva
 */
public class UIIntegerField extends UISimpleField<Long> {

	/* Properties */
	private UIFieldDataType dataType = new IntegerDataType();

	/**
	 * Constructor
	 */
	public UIIntegerField() {
		super();
	}

	/**
	 * Gets the field data type
	 * 
	 * @return the integer data type
	 */
	@Override
	public UIFieldDataType getDatatype() {
		return this.dataType;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public UIIntegerField createCopy() {
		UIIntegerField copy = new UIIntegerField();
		this.copyIntegerProperties(copy);
		return copy;
	}

	/* Copy the properties */
	protected void copyIntegerProperties(UIIntegerField copy) {
		super.copySimpleFieldProperties(copy);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void accept(IUIFieldVisitor visitor) {
		visitor.visit(this);
	}
}
