/*
 * Created on Feb 19, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.cms.portal.content.client.title.model.metadata.asset;

/**
 * UI Model object representing an 'Item' asset.
 * 
 * @author Vijay Silva
 */
public class UIItemAsset extends UIAsset {

	/* Properties */
	private String assetType;

	/**
	 * Constructor
	 */
	public UIItemAsset() {
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getAssetType() {
		return assetType;
	}

	/**
	 * @param assetType the assetType to set
	 */
	public void setAssetType(String assetType) {
		this.assetType = assetType;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public UIItemAsset createCopy() {
		UIItemAsset copy = new UIItemAsset();

		/* Copy the properties */
		this.copyProperties(copy);

		return copy;
	}

	/**
	 * Copy all properties of this item asset to the copy instance provided
	 * 
	 * @param copy The instance to copy properties to
	 */
	protected void copyProperties(UIItemAsset copy) {
		/* Copy all properties of the parent type */
		super.copyProperties(copy);

		/* Copy of properties of this item type */
		copy.setAssetType(this.getAssetType());
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void accept(IUIAssetVisitor visitor) {
		visitor.visit(this);
	}
}
