/*
 * Created on Feb 19, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.cms.portal.content.client.title.model.metadata.asset;

import com.tandbergtv.cms.portal.ui.title.client.model.datatype.UIFieldDataType;

/**
 * UI Model object that represents an asset field that contains a value.
 * 
 * @author Vijay Silva
 */
public abstract class UISimpleField<DataType> extends UIField {

	/* Properties */
	private Long id;
	private boolean attribute = false;
	private boolean nullify = false;
	private boolean autoFill = false;
	private DataType value;
	private String stringValue;

	/**
	 * Default Constructor
	 */
	public UISimpleField() {
	}

	/**
	 * @return the field id
	 */
	public Long getId() {
		return id;
	}

	/**
	 * @param id the field id to set
	 */
	public void setId(Long id) {
		this.id = id;
	}

	/**
	 * Get the string representation of the value for this field maintained by the backend.
	 * 
	 * @return The string value
	 */
	public String getStringValue() {
		return this.stringValue;
	}

	/**
	 * Set the string representation of the value for this field maintained by the backend.
	 * 
	 * @param stringValue The string value
	 */
	public void setStringValue(String stringValue) {
		this.value = null;
		this.stringValue = stringValue;
	}

	/**
	 * Get the value maintained by this field
	 * 
	 * @return The field value
	 */
	public DataType getValue() {
		return this.value;
	}

	/**
	 * Set the value maintained with this field
	 * 
	 * @param value The value
	 */
	public void setValue(DataType value) {
		this.stringValue = null;
		this.value = value;
	}

	/**
	 * Get the data type for this field
	 * 
	 * @return the data type
	 */
	public abstract UIFieldDataType getDatatype();

	/**
	 * @return the attribute
	 */
	public boolean isAttribute() {
		return attribute;
	}

	/**
	 * @param attribute the attribute to set
	 */
	public void setAttribute(boolean attribute) {
		this.attribute = attribute;
	}

	/**
	 * @return the autoFill
	 */
	public boolean isAutoFill() {
		return autoFill;
	}

	/**
	 * @param autoFill the autoFill to set
	 */
	public void setAutoFill(boolean autoFill) {
		this.autoFill = autoFill;
	}

	/**
	 * @return the nullify
	 */
	public boolean isNullify() {
		return nullify;
	}

	/**
	 * @param nullify the nullify to set
	 */
	public void setNullify(boolean nullify) {
		this.nullify = nullify;
	}

	/**
	 * Create a copy of this simple field
	 * 
	 * @return a copy of this field
	 */
	@Override
	public abstract UISimpleField<DataType> createCopy();

	/*
	 * Copy all properties to the copy instance
	 */
	protected void copySimpleFieldProperties(UISimpleField<DataType> copy) {
		super.copyProperties(copy);

		copy.setId(this.getId());
		copy.setAttribute(this.isAttribute());
		copy.setNullify(this.isNullify());
		copy.setAutoFill(this.isAutoFill());

		/* Copy the value and string value in shallow manner */
		copy.stringValue = this.stringValue;
		copy.value = this.value;
	}

	/**
	 * Get the value for the field that can be used for display purposes
	 * 
	 * @return The display value for the field
	 */
	public String getDisplayValue() {
		return (this.value != null) ? getValueAsString() : this.stringValue;
	}

	/**
	 * Gets the data type value as a string value. Default implementation returns the toString()
	 * value.
	 */
	protected String getValueAsString() {
		return (value != null) ? value.toString() : null;
	}
}
