/*
 * Created on Jun 4, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.cms.portal.content.client.title.model.metadata.asset;

import com.tandbergtv.cms.portal.ui.title.client.model.datatype.StringDataType;
import com.tandbergtv.cms.portal.ui.title.client.model.datatype.UIFieldDataType;

/**
 * A Simple Field that contains a string value
 * 
 * @author Vijay Silva
 */
public class UIStringField extends UISimpleField<String> {

	/* Properties */
	private UIFieldDataType dataType = new StringDataType();

	/**
	 * Constructor
	 */
	public UIStringField() {
		super();
	}

	/**
	 * Gets the field data type
	 * 
	 * @return the string data type
	 */
	@Override
	public UIFieldDataType getDatatype() {
		return this.dataType;
	}

	@Override
	public UIStringField createCopy() {
		UIStringField copy = new UIStringField();
		this.copyStringProperties(copy);
		return copy;
	}

	/* Copy the properties */
	protected void copyStringProperties(UIStringField copy) {
		super.copySimpleFieldProperties(copy);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void accept(IUIFieldVisitor visitor) {
		visitor.visit(this);
	}
}
