/*
 * Created on Jun 4, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.cms.portal.content.client.title.model.metadata.asset;

import com.tandbergtv.cms.portal.ui.title.client.model.datatype.TimeDataType;
import com.tandbergtv.cms.portal.ui.title.client.model.datatype.UIFieldDataType;

/**
 * A Simple Field that contains a time value
 * 
 * @author Vijay Silva
 */
public class UITimeField extends UISimpleField<String> {

	/* Properties */
	private UIFieldDataType dataType = new TimeDataType();
	
	/**
	 * Constructor
	 */
	public UITimeField() {
		super();
	}

	/**
	 * Gets the field data type
	 * 
	 * @return the time data type
	 */
	@Override
	public UIFieldDataType getDatatype() {
		return this.dataType;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public UITimeField createCopy() {
		UITimeField copy = new UITimeField();
		this.copyTimeProperties(copy);
		return copy;
	}

	/* Copy the properties */
	protected void copyTimeProperties(UITimeField copy) {
		super.copySimpleFieldProperties(copy);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void accept(IUIFieldVisitor visitor) {
		visitor.visit(this);
	}
}
